/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.model;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Paymark {
    private static final Logger LOGGER = LoggerFactory.getLogger(Paymark.class);

    public String run(String token) throws KeyException {
        try {
            if (this.checkToken(token)) {
                LOGGER.warn("Do pay business has exception when token is null...");
                throw new KeyException(AksExceptionEnum.AKS_99_00003.getCode(), AksExceptionEnum.AKS_99_00003.getDesc());
            }
            String string = this.doPay();
            return string;
        }
        catch (KeyException e) {
            LOGGER.error(e.getCode(), (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private boolean checkToken(String token) {
        return token == null || token.isEmpty();
    }

    public abstract String doPay() throws KeyException;
}

