/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security;

import com.jd.jr.aks.security.PropertiesLoader;
import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.util.StringUtils;

public class SecurityPropertySourceFactory
implements PropertySourceFactory {
    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        Properties props;
        String filename;
        if (name == null) {
            name = this.getNameForResource(resource.getResource());
        }
        if ((filename = resource.getResource().getFilename()) != null && (filename.endsWith(".yml") || filename.endsWith(".yaml"))) {
            YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
            factory.setResources(new Resource[]{resource.getResource()});
            factory.afterPropertiesSet();
            props = factory.getObject();
        } else {
            props = new Properties();
            PropertiesLoaderUtils.fillProperties((Properties)props, (EncodedResource)resource);
        }
        PropertiesLoader.decrypt(props);
        return new PropertiesPropertySource(name, props);
    }

    private String getNameForResource(Resource resource) {
        String name = resource.getDescription();
        if (!StringUtils.hasText((String)name)) {
            name = resource.getClass().getSimpleName() + "@" + System.identityHashCode(resource);
        }
        return name;
    }
}

