/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.crypto;

import com.jd.jr.aks.security.crypto.Decryption;
import com.jd.jr.aks.security.exception.DecryptException;
import com.jd.jr.aks.security.monitor.MonitorMessageBuilder;
import com.jd.jr.aks.security.utils.Verifys;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class AesCipher
implements Decryption {
    private static final String ENV_PASSWORD_KEY = "AKS_CONFIG_SECURITY_AES_PASSWORD";
    private static final String ALGO = "AES/ECB/PKCS5Padding";
    private static final String DEAD_KEY = "This is a key";
    private static final String KEYSPECALGO = "AES";
    private final Key key;

    public AesCipher() {
        String password = System.getenv(ENV_PASSWORD_KEY);
        if (password == null || "".equals(password)) {
            password = System.getProperty(ENV_PASSWORD_KEY);
        }
        if (password == null || "".equals(password)) {
            password = DEAD_KEY;
        }
        try {
            this.key = this.genKey(password);
        }
        catch (Exception e) {
            new MonitorMessageBuilder().className("AesCipher").methodName("constructor()").exception(e).send();
            throw new RuntimeException(e);
        }
        new MonitorMessageBuilder().className("AesCipher").methodName("constructor()").send();
    }

    public AesCipher(Key key) {
        this.key = key;
        new MonitorMessageBuilder().className("AesCipher").methodName("constructor(K)").send();
    }

    @Override
    public String decrypt(String ciphertext) throws DecryptException {
        try {
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(2, this.key);
            return new String(cipher.doFinal(DatatypeConverter.parseBase64Binary((String)ciphertext)), "UTF-8");
        }
        catch (Exception e) {
            throw new DecryptException(e);
        }
    }

    public String encrypt(String cleartext) {
        try {
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(1, this.key);
            return DatatypeConverter.printBase64Binary((byte[])cipher.doFinal(cleartext.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Key genKey(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] bytes;
        if (Verifys.notBase64(password) || (bytes = DatatypeConverter.parseBase64Binary((String)password)).length != 16) {
            bytes = password.getBytes("UTF-8");
        }
        if (bytes.length == 16) {
            return new SecretKeySpec(bytes, KEYSPECALGO);
        }
        KeyGenerator kgn = KeyGenerator.getInstance(KEYSPECALGO);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password.getBytes("UTF-8"));
        kgn.init(128, secureRandom);
        return kgn.generateKey();
    }

    public String encrypt(String cleartext, String password) {
        try {
            Key key = this.genKey(password);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(1, key);
            return DatatypeConverter.printBase64Binary((byte[])cipher.doFinal(cleartext.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

