/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.EncryptedDataLengthEnum;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.model.RadixEnum;
import com.wangyin.key.server.util.CryptUtil;
import com.wangyin.key.server.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Preconditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Preconditions.class);

    public static void validate(String ... args) throws KeyException {
        for (String arg : args) {
            if (arg != null && arg.length() != 0) continue;
            LOGGER.error("An exception occured when check argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
        }
    }

    public static void validate(byte[] ... args) throws KeyException {
        for (byte[] arg : args) {
            if (arg != null && arg.length != 0) continue;
            LOGGER.error("An exception occured when check argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
        }
    }

    public static void checkAliasName(String aliasName) {
        Preconditions.validate(aliasName);
        String[] nameList = aliasName.split("_");
        boolean isException = true;
        if (3 != nameList.length) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "aliasName = " + aliasName);
        }
        if (2 != nameList[1].length() && !"pass".equalsIgnoreCase(nameList[1])) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "aliasName = " + aliasName);
        }
        if ("01".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("02".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("03".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("04".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("05".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("11".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("12".equalsIgnoreCase(nameList[1])) {
            isException = false;
        } else if ("13".equalsIgnoreCase(nameList[1])) {
            isException = false;
        }
        if (isException && !"pass".equalsIgnoreCase(nameList[1])) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "aliasName = " + aliasName);
        }
    }

    public static void checkAliasName(String aliasName, AlgEnum alg) {
        Preconditions.checkAliasName(aliasName);
        if (alg != CryptUtil.getAlgByAliasName(aliasName)) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + " aliasName = " + aliasName);
        }
    }

    public static void checkMode(ModeEnum mode, byte[] iv) {
        if ("CBC".equals(mode.getCode()) && (null == iv || iv.length == 0)) {
            LOGGER.error(AksExceptionEnum.AKS_99_00009.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00009.getCode(), AksExceptionEnum.AKS_99_00009.getDesc());
        }
    }

    public static void checkPlaintext(String aliasName, PaddingEnum paddingEnum, byte[] srcData) {
        if (paddingEnum.equals((Object)PaddingEnum.PADDING_NOPADDING)) {
            boolean isException = false;
            AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
            switch (alg) {
                case ALG_3DES: {
                    isException = srcData.length % EncryptedDataLengthEnum.ALG_3DES192_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES: {
                    isException = srcData.length % EncryptedDataLengthEnum.ALG_AES128_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES192: {
                    isException = srcData.length % EncryptedDataLengthEnum.ALG_AES192_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES256: {
                    isException = srcData.length % EncryptedDataLengthEnum.ALG_AES256_LEN.getLen() != 0;
                    break;
                }
                case ALG_SM4: {
                    isException = srcData.length % EncryptedDataLengthEnum.ALG_SM4_LEN.getLen() != 0;
                    break;
                }
            }
            if (isException) {
                LOGGER.error(AksExceptionEnum.AKS_99_00075.getCode(), (Object)(AksExceptionEnum.AKS_99_00075.getDesc() + "alg = " + alg.getCode() + ", length = " + srcData.length));
                throw new KeyException(AksExceptionEnum.AKS_99_00075.getCode(), AksExceptionEnum.AKS_99_00075.getDesc() + "alg = " + alg.getCode() + ", length = " + srcData.length);
            }
        }
    }

    public static void checkPlaintextAsymm(AlgEnum alg, byte[] srcData) {
        boolean isException = false;
        switch (alg) {
            case ALG_RSA1024: {
                isException = srcData.length > EncryptedDataLengthEnum.ALG_RSA1024_LEN.getLen() - 11;
                break;
            }
            case ALG_RSA2048: {
                isException = srcData.length > EncryptedDataLengthEnum.ALG_RSA2048_LEN.getLen() - 11;
                break;
            }
            case ALG_SM2: {
                isException = false;
            }
        }
        if (isException) {
            LOGGER.error(AksExceptionEnum.AKS_99_00084.getCode(), (Object)AksExceptionEnum.AKS_99_00084.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00084.getCode(), AksExceptionEnum.AKS_99_00084.getDesc() + "alg = " + alg.getCode() + ", length = " + srcData.length);
        }
    }

    public static void checkEncryptedData(AlgEnum alg, byte[] encData) {
        boolean isException = false;
        if (AlgEnum.ALG_RSA1024 != alg && AlgEnum.ALG_RSA2048 != alg && AlgEnum.ALG_SM2 != alg && encData.length % 2 != 0) {
            isException = true;
        } else {
            switch (alg) {
                case ALG_3DES: {
                    isException = encData.length % EncryptedDataLengthEnum.ALG_3DES192_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES: {
                    isException = encData.length % EncryptedDataLengthEnum.ALG_AES128_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES192: {
                    isException = encData.length % EncryptedDataLengthEnum.ALG_AES192_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES256: {
                    isException = encData.length % EncryptedDataLengthEnum.ALG_AES256_LEN.getLen() != 0;
                    break;
                }
                case ALG_SM4: {
                    isException = encData.length % EncryptedDataLengthEnum.ALG_SM4_LEN.getLen() != 0;
                    break;
                }
                case ALG_RSA1024: {
                    isException = encData.length > EncryptedDataLengthEnum.ALG_RSA1024_LEN.getLen();
                    break;
                }
                case ALG_RSA2048: {
                    isException = encData.length > EncryptedDataLengthEnum.ALG_RSA2048_LEN.getLen();
                    break;
                }
                case ALG_SM2: {
                    isException = false;
                }
            }
        }
        if (isException) {
            LOGGER.error(AksExceptionEnum.AKS_99_00010.getCode(), (Object)AksExceptionEnum.AKS_99_00010.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00010.getCode(), AksExceptionEnum.AKS_99_00010.getDesc() + "alg = " + alg.getCode() + ", length = " + encData.length);
        }
    }

    public static void checkEncryptedDataByVersion(AlgEnum alg, byte[] encData) {
        boolean isException = false;
        if (AlgEnum.ALG_RSA1024 == alg || AlgEnum.ALG_RSA2048 == alg || AlgEnum.ALG_SM2 == alg) {
            isException = true;
        } else {
            switch (alg) {
                case ALG_3DES: {
                    isException = (encData.length - 21) % EncryptedDataLengthEnum.ALG_3DES192_LEN.getLen() != 0 && encData.length % EncryptedDataLengthEnum.ALG_3DES192_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES: {
                    isException = (encData.length - 21) % EncryptedDataLengthEnum.ALG_AES128_LEN.getLen() != 0 && encData.length % EncryptedDataLengthEnum.ALG_AES128_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES192: {
                    isException = (encData.length - 21) % EncryptedDataLengthEnum.ALG_AES192_LEN.getLen() != 0 && encData.length % EncryptedDataLengthEnum.ALG_AES192_LEN.getLen() != 0;
                    break;
                }
                case ALG_AES256: {
                    isException = (encData.length - 21) % EncryptedDataLengthEnum.ALG_AES256_LEN.getLen() != 0 && encData.length % EncryptedDataLengthEnum.ALG_AES256_LEN.getLen() != 0;
                    break;
                }
                case ALG_SM4: {
                    isException = (encData.length - 21) % EncryptedDataLengthEnum.ALG_SM4_LEN.getLen() != 0 && encData.length % EncryptedDataLengthEnum.ALG_SM4_LEN.getLen() != 0;
                    break;
                }
            }
        }
        if (isException) {
            LOGGER.error(AksExceptionEnum.AKS_99_00010.getCode(), (Object)AksExceptionEnum.AKS_99_00010.getDesc(), (Object)"\uff08\u5e26\u5bc6\u94a5\u7248\u672c\u4fe1\u606f\uff09");
            throw new KeyException(AksExceptionEnum.AKS_99_00010.getCode(), AksExceptionEnum.AKS_99_00010.getDesc());
        }
    }

    public static void checkIsBase64Data(String ... args) {
        for (String base64Data : args) {
            if (StringUtil.isBase64(base64Data)) continue;
            LOGGER.error(AksExceptionEnum.AKS_99_00011.getCode(), (Object)AksExceptionEnum.AKS_99_00011.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00011.getCode(), AksExceptionEnum.AKS_99_00011.getDesc());
        }
    }

    public static void checkWalletIdLength(int walletIdLength) throws KeyException {
        if (18 != walletIdLength) {
            LOGGER.error(AksExceptionEnum.AKS_99_00008.getCode(), (Object)(AksExceptionEnum.AKS_99_00008.getDesc() + "18 != walletIdLength"));
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "18 != walletIdLength");
        }
    }

    public static void checkStatusCode(String ... codes) throws KeyException {
        boolean flag = false;
        for (String code : codes) {
            if ("1".equals(code) || "0".equals(code)) continue;
            flag = true;
            break;
        }
        if (flag) {
            LOGGER.error(AksExceptionEnum.AKS_99_00008.getCode(), (Object)AksExceptionEnum.AKS_99_00008.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc());
        }
    }

    public static void checkStringIsNumber(String value) throws KeyException {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(value);
        if (!isNum.matches()) {
            LOGGER.error(AksExceptionEnum.AKS_99_00008.getCode(), (Object)AksExceptionEnum.AKS_99_00008.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "checkStringIsNumber");
        }
    }

    public static void checkOtpcode(String otpcode) {
        if (16 != otpcode.length() && 20 != otpcode.length()) {
            LOGGER.error(AksExceptionEnum.AKS_99_00008.getCode(), (Object)AksExceptionEnum.AKS_99_00008.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc());
        }
        Preconditions.checkStringIsNumber(otpcode);
        Preconditions.checkPayCodeFormat(otpcode);
    }

    public static void checkCertAliasName(String aliasName) {
        Preconditions.checkAliasName(aliasName);
        if (!("11".equals(CryptUtil.getAlgtype(aliasName)) || "12".equals(CryptUtil.getAlgtype(aliasName)) || "13".equals(CryptUtil.getAlgtype(aliasName)))) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "certAliasName = " + aliasName);
        }
    }

    public static void checkToken(String token) {
        Preconditions.validate(token);
        if (32 != token.length()) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "32 != token.length()");
        }
    }

    public static void checkPasswordAliasName(String aliasName) {
        Preconditions.validate(aliasName);
        String[] nameList = aliasName.split("_");
        boolean isException = false;
        if (3 != nameList.length) {
            isException = true;
        } else if (!"pass".equals(nameList[1])) {
            isException = true;
        }
        if (isException) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "passAliasName = " + aliasName);
        }
    }

    public static void validate(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv) {
        Preconditions.checkAliasName(aliasName);
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        boolean isPaddingOK = false;
        switch (alg) {
            case ALG_3DES: 
            case ALG_AES: 
            case ALG_AES192: 
            case ALG_AES256: 
            case ALG_SM4: {
                isPaddingOK = PaddingEnum.PADDING_PKCS5 == padding || PaddingEnum.PADDING_PKCS7 == padding || PaddingEnum.PADDING_NOPADDING == padding;
                break;
            }
        }
        if (!isPaddingOK) {
            LOGGER.error("An exception occured when check padding argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00023.getCode(), AksExceptionEnum.AKS_99_00023.getDesc());
        }
        if (null == iv && mode == ModeEnum.MODE_CBC) {
            LOGGER.error("An exception occured when check iv argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00009.getCode(), AksExceptionEnum.AKS_99_00009.getDesc());
        }
        if (ModeEnum.MODE_CBC == mode && AlgEnum.ALG_3DES == alg && iv.length != "8a6c4ddd".length()) {
            LOGGER.error("An exception occured when check iv argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00009.getCode(), AksExceptionEnum.AKS_99_00009.getDesc());
        }
        if (ModeEnum.MODE_CBC == mode && AlgEnum.ALG_3DES != alg && iv.length != "8a6c4ddd8a6c4ddd".length()) {
            LOGGER.error("An exception occured when check iv argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00009.getCode(), AksExceptionEnum.AKS_99_00009.getDesc());
        }
    }

    public static void validateForSysmVersion(String aliasName, ModeEnum mode, PaddingEnum padding) {
        Preconditions.checkAliasName(aliasName);
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        boolean isPaddingOK = false;
        switch (alg) {
            case ALG_3DES: 
            case ALG_AES: 
            case ALG_AES192: 
            case ALG_AES256: 
            case ALG_SM4: {
                isPaddingOK = PaddingEnum.PADDING_PKCS5 == padding || PaddingEnum.PADDING_PKCS7 == padding || PaddingEnum.PADDING_NOPADDING == padding;
                break;
            }
        }
        if (!isPaddingOK) {
            LOGGER.error("An exception occured when check padding argument failed");
            throw new KeyException(AksExceptionEnum.AKS_99_00023.getCode(), AksExceptionEnum.AKS_99_00023.getDesc());
        }
    }

    public static void checkDataToMAC(String dataToMAC) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9, _.]+");
        boolean isMatcher = pattern.matcher(dataToMAC).matches();
        if (!isMatcher) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc());
        }
    }

    protected static void checkPayCodeFormat(String payCodeStr) throws KeyException {
        boolean isRepeat = true;
        char value = payCodeStr.charAt(0);
        for (int i = 0; i < payCodeStr.length(); ++i) {
            char c = payCodeStr.charAt(i);
            if (value == c) continue;
            isRepeat = false;
        }
        if (isRepeat) {
            LOGGER.error("{} \u4ed8\u6b3e\u7801 {}", (Object)AksExceptionEnum.AKS_99_00044.getDesc(), (Object)payCodeStr);
            throw new KeyException(AksExceptionEnum.AKS_99_00044.getCode(), AksExceptionEnum.AKS_99_00044.getDesc());
        }
    }

    public static void checkFF1DataType(RadixEnum radix, String srcData) {
        if (radix.equals((Object)RadixEnum.Radix_64) && !StringUtil.isBase64(srcData)) {
            LOGGER.error(AksExceptionEnum.AKS_99_00008.getCode(), (Object)AksExceptionEnum.AKS_99_00008.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "radix = " + radix.getDesc());
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(srcData);
        if (radix.equals((Object)RadixEnum.Radix_10) && !isNum.matches()) {
            LOGGER.error(AksExceptionEnum.AKS_99_00008.getCode(), (Object)AksExceptionEnum.AKS_99_00008.getDesc());
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "radix = " + radix.getDesc());
        }
    }

    public void validate(String aliasName, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv) {
        Preconditions.validate(aliasName, mode, padding, iv);
    }
}

