/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.model.Status;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatusUtil {
    public static final String VERSION = "2.1.8";
    public static final boolean GLOBAL_MONITOR = !"true".equalsIgnoreCase(System.getProperty("aks.fmq.disable"));
    private static final Map<String, Status> statusMap = new ConcurrentHashMap<String, Status>();
    private static final StatusUtil statusUtil = new StatusUtil();

    private StatusUtil() {
    }

    public static StatusUtil getInstance() {
        return statusUtil;
    }

    public static String getApiVersion() {
        return VERSION;
    }

    public void setStatus(String key, Status status) {
        statusMap.put(key, status);
    }

    public void setStatusInitiative(String key, boolean isOffLine) {
        Status status = statusMap.get(key);
        status.setLastTime(new Date());
        status.setOffLine(isOffLine);
        status.setInitiative(true);
    }

    public void setOffLineStatus(String key) {
        Status status = statusMap.get(key);
        if (!status.isOffLine()) {
            status.setLastTime(new Date());
            status.setOffLine(true);
            status.setInitiative(false);
        }
    }

    public void setStatusIsOffline(String key, boolean isOffLine) {
        Status status = statusMap.get(key);
        status.setLastTime(new Date());
        status.setOffLine(isOffLine);
        status.setInitiative(false);
    }

    @Deprecated
    public Status getStatus(String key) {
        return statusMap.get(key);
    }

    public boolean isOnLine(String key) {
        if (key == null) {
            return false;
        }
        Status status = statusMap.get(key);
        return status != null && !status.isOffLine();
    }

    public boolean isInitiative(String key) {
        Status status = statusMap.get(key);
        return status.isInitiative();
    }

    public boolean isLogout(String key) {
        Status status = statusMap.get(key);
        return status.isLogout();
    }

    public void setLogout(String key, boolean logout) {
        Status status = statusMap.get(key);
        status.setLogout(logout);
    }

    public Date getLastTime(String key) {
        Status status = statusMap.get(key);
        return status.getLastTime();
    }

    public boolean isMonitor(String key) {
        if (key == null) {
            return GLOBAL_MONITOR;
        }
        Status status = statusMap.get(key);
        if (status == null) {
            return GLOBAL_MONITOR;
        }
        return GLOBAL_MONITOR && status.isMonitor();
    }

    public void setMonitor(String key, boolean monitor) {
        if (key == null) {
            return;
        }
        Status status = statusMap.get(key);
        if (status == null) {
            return;
        }
        status.setMonitor(monitor);
    }
}

