package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.expert.model.request.CompanyPageReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.response.DictListResp;
import com.cnooc.expert.controller.expert.model.response.NofilterListResp;
import com.cnooc.expert.controller.expert.model.response.SecondaryUnitListResp;
import com.cnooc.expert.service.ExpertService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/expert")
public class ExpertController {

    private final ExpertService expertService;

    @GetMapping("/get")
    public String expertGet() throws JsonProcessingException {
        return expertService.getExpertDetail(1);
    }

    // *** 数据字典 ***

    /**
     * 民族查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/nofilter/list")
    public ApiResult<NofilterListResp> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        return ApiResult.successWithResult(expertService.listDictNofilter(req));
    }

    /**
     * 集团二级单位列表
     *
     * @return
     */
    @PostMapping("/secondary-unit/list")
    public ApiResult<SecondaryUnitListResp> secondaryUnitList() {
        return ApiResult.successWithResult(expertService.listSecondaryUnit());
    }

    /**
     * 职称列表
     *
     * @return
     */
    @PostMapping("/dict/guid4/list")
    public ApiResult<DictListResp> dictGuiud4List() {
        return ApiResult.successWithResult(expertService.listDict4());
    }

    /**
     * 学历列表
     *
     * @return
     */
    @PostMapping("/dict/guid5/list")
    public ApiResult<DictListResp> dictGuiud5List() {
        return ApiResult.successWithResult(expertService.listDict5());
    }


    /**
     * 学位列表
     *
     * @return
     */
    @PostMapping("/dict/guid6/list")
    public ApiResult<DictListResp> dictGuiud6List() {
        return ApiResult.successWithResult(expertService.listDict6());
    }

    /**
     * 公司列表
     * @return
     */
    @PostMapping("/company/page")
    public ApiResult<BasePageResp<Object>> companyPage(@RequestBody @Validated CompanyPageReq req) {
        return ApiResult.successWithResult(expertService.pageCompany(req));
    }



}
