/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.model.Cache;
import com.wangyin.key.server.model.CertCache;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheUtil {
    private static final Map<String, Cache> cache = new ConcurrentHashMap<String, Cache>();
    private static final CacheUtil cacheUtil = new CacheUtil();

    private CacheUtil() {
    }

    public static CacheUtil getInstance() {
        return cacheUtil;
    }

    public void setCache(String key, Cache c) {
        cache.put(key, c);
    }

    public String getApiVersion(String key) throws KeyException {
        Cache c = cache.get(key);
        if (null == c) {
            throw new KeyException(AksExceptionEnum.AKS_99_00012.getCode(), AksExceptionEnum.AKS_99_00012.getDesc());
        }
        return c.getApiVersion();
    }

    public String getServerVersion(String key) throws KeyException {
        Cache c = cache.get(key);
        if (null == c) {
            throw new KeyException(AksExceptionEnum.AKS_99_00012.getCode(), AksExceptionEnum.AKS_99_00012.getDesc());
        }
        return c.getServerVersion();
    }

    public String getToken(String key) throws KeyException {
        Cache c = cache.get(key);
        if (null == c) {
            throw new KeyException(AksExceptionEnum.AKS_99_00012.getCode(), AksExceptionEnum.AKS_99_00012.getDesc());
        }
        return c.getToken();
    }

    public boolean getStatus(String key) throws KeyException {
        Cache c = this.getCache(key);
        if (null != c) {
            return c.getStatus();
        }
        return false;
    }

    private Cache getCache(String key) throws KeyException {
        return cache.get(key);
    }

    public synchronized CertCache getCertCache(String key, String alias) throws KeyException {
        List<CertCache> certs;
        Cache c = this.getCache(key);
        if (null != c && null != (certs = c.getCerts())) {
            for (CertCache certCache : certs) {
                if (!alias.equals(certCache.getAlias())) continue;
                return certCache;
            }
        }
        return null;
    }

    public synchronized void updateCertCache(String key, String alias, String certB64) throws KeyException {
        List<CertCache> certs;
        Cache c = this.getCache(key);
        if (null != c && null != (certs = c.getCerts())) {
            for (CertCache certCache : certs) {
                if (!alias.equals(certCache.getAlias())) continue;
                certCache.setCert(certB64);
            }
        }
    }
}

