package com.cnooc.expert.controller.workflow;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingPageResp;
import com.cnooc.expert.service.WorkflowMockService;
import com.cnooc.expert.service.WorkflowService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/mock/workflow")
public class WorkflowMockController extends AbstractBaseController {

    private final WorkflowMockService workflowMockService;

    // 获取审批路径
    @PostMapping("/approve-path-setting/page")
    public ApiResult<BasePageResp<ApprovePathSettingPageResp>> pageApprovePathSetting(@RequestBody @Validated ApprovePathSettingPageReq req) {
        return ApiResult.successWithResult(workflowMockService.pageApprovePathSetting(req));
    }

}
