package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.expert.model.request.CommonFuJianListReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.request.DongJieGetReq;
import com.cnooc.expert.controller.expert.model.request.DongJiePageReq;
import com.cnooc.expert.controller.expert.model.request.ExamPaperGetReq;
import com.cnooc.expert.controller.expert.model.request.ExamQuestionListReq;
import com.cnooc.expert.controller.expert.model.request.ExamQuestionXiaoTiListReq;
import com.cnooc.expert.controller.expert.model.request.ExamRecordSaveReq;
import com.cnooc.expert.controller.expert.model.request.ExpertInfoGetByBusinessIdReq;
import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.controller.expert.model.request.FirstCategoryExpertApplyReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaApplyReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaPageReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaZhuXiaoTimeUpdateReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuByOwnerPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuInfoGetByChouQuMaReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiApplyReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiPageReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseGetInfoReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseLessonGetReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseLessonPageReq;
import com.cnooc.expert.controller.expert.model.request.TrainCoursePageReq;
import com.cnooc.expert.controller.expert.model.request.TrainExamPageReq;
import com.cnooc.expert.controller.expert.model.request.ViolationGetReq;
import com.cnooc.expert.controller.expert.model.request.ViolationPageReq;
import com.cnooc.expert.controller.expert.model.request.ZhuanJiaShenQingJiLuPageReq;
import com.cnooc.expert.controller.expert.model.response.ApproveBusinessIdGetResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoZhuanYeTreeNodeResp;
import com.cnooc.expert.controller.expert.model.response.ZhuanJiaShenQingJiLuPageResp;
import com.cnooc.expert.external.expert.model.request.ApproveNodeGetApiReq;
import com.cnooc.expert.external.expert.model.request.ExamPaperSubmitApiReq;
import com.cnooc.expert.external.expert.model.request.TainLessonProgressUpdateApiReq;
import com.cnooc.expert.external.expert.model.response.ApproveNodeGetApiResp;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonFuJianListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieGetApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExamPaperSubmitApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionXiaoTiListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamRecordSaveApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.FirstCategoryExpertApplyApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaZhuXiaoTimeUpdateApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.TainLessonProgressUpdateApiResp;
import com.cnooc.expert.external.expert.model.response.TempExamPaperGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonPageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainExamPageApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaInfoGetByBusinessIdApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaPingBiaoXiangMuRenWuPageApiResp;
import com.cnooc.expert.service.expert.ExpertService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/expert")
public class ExpertController extends AbstractBaseController {

    private final ExpertService expertService;

    // 获取 工作流业务id
    @PostMapping("/approve/getBusinessId")
    public ApiResult<ApproveBusinessIdGetResp> approveBusinessIdGet() {
        String approveBusinessId = expertService.getApproveBusinessId();

        return ApiResult.successWithResult(
                ApproveBusinessIdGetResp.builder()
                        .businessId(approveBusinessId)
                        .build()
        );
    }

    // 获取审批节点
    @PostMapping("/approve/node/list")
    public ApiResult<List<ApproveNodeGetApiResp>> getApproveNodeList(@RequestBody @Validated ApproveNodeGetApiReq req) {
        List<ApproveNodeGetApiResp> apiResp = expertService.getApproveNodeList(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 个人信息 ***

    // 民族列表
    @PostMapping("/nofilter/list")
    public ApiResult<List<CommonNofilterEnumGetApiResp>> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        List<CommonNofilterEnumGetApiResp> apiResp = expertService.listDictNofilter(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 集团二级单位列表
    @PostMapping("/secondary-unit/list")
    public ApiResult<List<CommonJiTuanErJiDanWeiListApiResp>> secondaryUnitList() {
        List<CommonJiTuanErJiDanWeiListApiResp> apiResp = expertService.listSecondaryUnit();
        return ApiResult.successWithResult(apiResp);
    }

    // 职称列表
    @PostMapping("/dict/guid3/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud3List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict3();
        return ApiResult.successWithResult(apiResp);
    }

    // 执业资格列表
    @PostMapping("/dict/guid4/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud4List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict4();
        return ApiResult.successWithResult(apiResp);
    }

    // 学历列表
    @PostMapping("/dict/guid5/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud5List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict5();
        return ApiResult.successWithResult(apiResp);
    }

    // 学位列表
    @PostMapping("/dict/guid6/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud6List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict6();
        return ApiResult.successWithResult(apiResp);
    }

    // 语种列表
    @PostMapping("/dict/guid11/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud11List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict11();
        return ApiResult.successWithResult(apiResp);
    }

    // 熟练程度列表
    @PostMapping("/dict/guid12/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud12List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict12();
        return ApiResult.successWithResult(apiResp);
    }

    // 评标专业树
    @PostMapping("/ping-biao-zhuan-ye/tree")
    public ApiResult<List<PingBiaoZhuanYeTreeNodeResp>> PingBiaoZhuanYeTree() {
        List<PingBiaoZhuanYeTreeNodeResp> apiResp = expertService.treePingBiaoZhuanYe();
        return ApiResult.successWithResult(apiResp);
    }

    // 省市区树
    @PostMapping("/city/tree")
    public ApiResult<List<CityTreeApiResp>> cityTree() {
        List<CityTreeApiResp> apiResp = expertService.treeCity();
        return ApiResult.successWithResult(apiResp);
    }

    // 专家个人信息详情
    @PostMapping("/info")
    public ApiResult<ExpertInfoGetApiResp> expertInfoGet() {
        ExpertInfoGetApiResp apiResp = expertService.getExpertInfo(null);
        return ApiResult.successWithResult(apiResp);
    }

    // 专家个人信息修改
    @PostMapping("/updateAllInfo")
    public ApiResult<ExpertInfoGetApiResp> expertInfoUpdate(@RequestBody @Validated ExpertInfoUpdateApiReq req) {
        ExpertInfoGetApiResp apiResp = expertService.updateExpertInfo(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 申请成为一级专家
    @PostMapping("/first-category-expert/apply")
    public ApiResult<FirstCategoryExpertApplyApiResp> applyFirstCategoryExpert(@RequestBody @Validated FirstCategoryExpertApplyReq req) {
        FirstCategoryExpertApplyApiResp apiResp = expertService.applyFirstCategoryExpert(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 根据BusinessId获取专家信息
    @PostMapping("/info-by-businessId")
    public ApiResult<ZhuanJiaInfoGetByBusinessIdApiResp> expertInfoByBusinessId(@RequestBody @Validated ExpertInfoGetByBusinessIdReq req) {
        ZhuanJiaInfoGetByBusinessIdApiResp apiResp = expertService.getZhuanJiaInfoByBusinessId(req.getBusinessId());
        return ApiResult.successWithResult(apiResp);
    }

    // 专家个人的申请列表
    @PostMapping("/zhuan-jia/shen-qing-ji-lu/page")
    public ApiResult<BasePageResp<ZhuanJiaShenQingJiLuPageResp>> zhuanJiaShenQingJiLuPage(@RequestBody @Validated ZhuanJiaShenQingJiLuPageReq req) {
        BasePageResp<ZhuanJiaShenQingJiLuPageResp> apiResp = expertService.pageZhuanJiaShenQingJiLu(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 请假/休假 ***

    // 根据抽取码获取评标项目
    @PostMapping("/pingBiaoXiangMu/info-by-chouqunum")
    public ApiResult<XiangMuInfoByChouQuNumGetApiResp> pingBiaoXiangMuInfoGetByChouQuMa(@RequestBody @Validated PingBiaoXiangMuInfoGetByChouQuMaReq req) {
        XiangMuInfoByChouQuNumGetApiResp apiResp = expertService.getPingBiaoXiangMuInfoByChouQuMa(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 专家所属评标项目分页
    @PostMapping("/pingBiaoXiangMu/page")
    public ApiResult<BasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>> pingBiaoXiangMuPage(@RequestBody @Validated PingBiaoXiangMuByOwnerPageReq req) {
        BasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp> apiResp = expertService.pagePingBiaoXiangmuByOwner(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 紧急请假分页列表
    @PostMapping("/qing-jia/page")
    public ApiResult<BasePageResp<JinJiQingJiaPageApiResp>> qingJiaJinJiPage(@RequestBody @Validated QingJiaJinJiPageReq req) {
        BasePageResp<JinJiQingJiaPageApiResp> apiResp = expertService.pageJinJiQingJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 紧急请假申请
    @PostMapping("/qing-jia/apply")
    public ApiResult<JinJiQingJiaApplyApiResp> qingJiaJinJiApply(@RequestBody @Validated QingJiaJinJiApplyReq req) {
        JinJiQingJiaApplyApiResp apiResp = expertService.applyJinJiQingJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 个人休假分页列表
    @PostMapping("/xiu-jia/page")
    public ApiResult<BasePageResp<GeRenXiuJiaPageApiResp>> geRenXiuJiaPage(@RequestBody @Validated GeRenXiuJiaPageReq req) {
        BasePageResp<GeRenXiuJiaPageApiResp> apiResp = expertService.pageGeRenXiuJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 个人休假申请
    @PostMapping("/xiu-jia/apply")
    public ApiResult<GeRenXiuJiaApplyApiResp> geRenXiuJiaApply(@RequestBody @Validated GeRenXiuJiaApplyReq req) {
        GeRenXiuJiaApplyApiResp apiResp = expertService.applyGeRenXiuJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 个人休假注销
    @PostMapping("/xiu-jia/updateZhuXiaoTime")
    public ApiResult<GeRenXiuJiaZhuXiaoTimeUpdateApiResp> geRenXiuJiaApply(@RequestBody @Validated GeRenXiuJiaZhuXiaoTimeUpdateReq req) {
        GeRenXiuJiaZhuXiaoTimeUpdateApiResp apiResp = expertService.updateGeRenXiuJiaZhuXiaoTime(req.getQingJiaGuid());
        return ApiResult.successWithResult(apiResp);
    }

    // *** 评标项目 ***

    // 专家所属评标项目分页（请假状态）
    @PostMapping("/ping-biao-xiang-mu/by-owner/page")
    public ApiResult<BasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>> pingBiaoXiangMuByOwnerPage(@RequestBody @Validated PingBiaoXiangMuByOwnerPageReq req) {
        BasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp> apiResp = expertService.pagePingBiaoXiangmuByOwner(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 违规/冻结 ***

    // 专家冻结分页
    @PostMapping("/dong-jie/page")
    public ApiResult<BasePageResp<DongJieZhuanYePageApiResp>> dongJiePage(@RequestBody @Validated DongJiePageReq req) {
        BasePageResp<DongJieZhuanYePageApiResp> apiResp = expertService.pageDongJie(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 专家冻结详情
    @PostMapping("/dong-jie/get")
    public ApiResult<DongJieGetApiResp> dongJieGet(@RequestBody @Validated DongJieGetReq req) {
        DongJieGetApiResp apiResp = expertService.getDongJie(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 专家违规分页列表
    @PostMapping("/wei-gui/page")
    public ApiResult<BasePageResp<ViolationExpertPageApiResp>> violationPage(@RequestBody @Validated ViolationPageReq req) {
        BasePageResp<ViolationExpertPageApiResp> apiResp = expertService.pageWeiGuiList(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 专家违规详情
    @PostMapping("/wei-gui/get")
    public ApiResult<ViolationExpertGetApiResp> violationGet(@RequestBody @Validated ViolationGetReq req) {
        ViolationExpertGetApiResp apiResp = expertService.getViolation(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 培训 / 考试 ***

    // 培训课程分页
    @PostMapping("/train/course/page")
    public ApiResult<BasePageResp<TrainCoursePageApiResp>> pageTrainCourse(@RequestBody @Validated TrainCoursePageReq req) {
        BasePageResp<TrainCoursePageApiResp> apiResp = expertService.pageTrainCourse(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 培训课程详情
    @PostMapping("/train/course/get")
    public ApiResult<TrainCourseGetApiResp> getTrainCourseInfo(@RequestBody @Validated TrainCourseGetInfoReq req) {
        TrainCourseGetApiResp apiResp = expertService.getTrainCourse(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 培训课程课节分页
    @PostMapping("/train/course/lesson/page")
    public ApiResult<BasePageResp<TrainCourseLessonPageApiResp>> pageTrainCourseLesson(@RequestBody @Validated TrainCourseLessonPageReq req) {
        BasePageResp<TrainCourseLessonPageApiResp> apiResp = expertService.pageTrainCourseLesson(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 培训课程课节详情
    @PostMapping("/train/course/lesson/get")
    public ApiResult<TrainCourseLessonGetApiResp> getTrainCourseLesson(@RequestBody @Validated TrainCourseLessonGetReq req) {
        TrainCourseLessonGetApiResp apiResp = expertService.getTrainCourseLesson(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 附件列表
    @PostMapping("/common/fu-jian/list")
    public ApiResult<List<CommonFuJianListApiResp>> listCommonFuJian(@RequestBody @Validated CommonFuJianListReq req) {
        List<CommonFuJianListApiResp> apiResp = expertService.listCommonFuJian(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 更新培训课节学习进度
    @PostMapping("/train/lesson-progress/update")
    public ApiResult<TainLessonProgressUpdateApiResp> updateTainLessonProgress(@RequestBody TainLessonProgressUpdateApiReq req) {
        TainLessonProgressUpdateApiResp apiResp = expertService.updateTainLessonProgress(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 考试分页
    @PostMapping("/train/exam/page")
    public ApiResult<BasePageResp<TrainExamPageApiResp>> trainExamPage(@RequestBody @Validated TrainExamPageReq req) {
        BasePageResp<TrainExamPageApiResp> apiResp = expertService.pageTrainExam(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 查询试卷信息
    @PostMapping("/train/exam/paper/get")
    public ApiResult<TempExamPaperGetApiResp> examPaperGet(@RequestBody @Validated ExamPaperGetReq req) {
        TempExamPaperGetApiResp apiResp = expertService.getTempExamPaper(req.getExamPaperGuid());
        return ApiResult.successWithResult(apiResp);
    }

    // 获取系统时间
    @PostMapping("/common/systemtime/get")
    public ApiResult<Long> commonSystemtimeGet() {
        return ApiResult.successWithResult(expertService.getSystemTime());
    }

    // 保存考试记录
    @PostMapping("/train/exam/record/save")
    public ApiResult<ExamRecordSaveApiResp> examRecordSave(@RequestBody @Validated ExamRecordSaveReq req) {
        ExamRecordSaveApiResp apiResp = expertService.saveExamRecord(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 考试试题列表
    @PostMapping("/train/exam/question/list")
    public ApiResult<List<ExamQuestionListApiResp>> examQuestionList(@RequestBody @Validated ExamQuestionListReq req) {
        List<ExamQuestionListApiResp> apiResp = expertService.listExamQuestion(req.getExamPaperGuid());
        return ApiResult.successWithResult(apiResp);
    }

    // 考试试题小题列表
    @PostMapping("/train/exam/question/xiaoti/list")
    public ApiResult<List<ExamQuestionXiaoTiListApiResp>> examQuestionXiaoTiList(@RequestBody @Validated ExamQuestionXiaoTiListReq req) {
        List<ExamQuestionXiaoTiListApiResp> apiResp = expertService.listExamQuestionXiaoTi(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 提交试卷
    @PostMapping("/train/exam/question/paperr/submit")
    public ApiResult<ExamPaperSubmitApiResp> examQuestionPaperSubmit(@RequestBody @Validated ExamPaperSubmitApiReq req) {
        ExamPaperSubmitApiResp apiResp = expertService.submitExamPaper(req);
        return ApiResult.successWithResult(apiResp);
    }
}
