package com.cnooc.expert.controller.portal;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.portal.model.request.AgentNumReq;
import com.cnooc.expert.controller.portal.model.request.AgentPageReq;
import com.cnooc.expert.controller.portal.model.request.MessagePageReq;
import com.cnooc.expert.controller.portal.model.response.AgentNumResp;
import com.cnooc.expert.controller.portal.model.response.MessageNumResp;
import com.cnooc.expert.service.portal.PortalMockService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/mock/portal")
public class PortalMockController extends AbstractBaseController {

    private final PortalMockService portalMockService;

    // *** 业务待办 ***

    @PostMapping("/agent/num/test")
    public String agentNumTest(AgentNumReq req) throws JsonProcessingException {
        return objectMapper.writeValueAsString(portalMockService.getAgentNum(req));
    }

    /**
     * 已办待办数量
     *
     * @return
     */
    @PostMapping("/agent/num")
    public ApiResult<AgentNumResp> agentNum(AgentNumReq req) {
        return ApiResult.successWithResult(portalMockService.getAgentNum(req));
    }

    /**
     * 已办待办分页列表
     *
     * @return
     */
    @PostMapping("/agent/page")
    public ApiResult<BasePageResp<Object>> agentPage(@RequestBody @Validated AgentPageReq req) {
        int curUserId = 1;
        return ApiResult.successWithResult(portalMockService.pageAgentNum(req));
    }

    // *** 我的消息 ***

    /**
     * 已读未读数量查询
     *
     * @return
     */
    @PostMapping("/message/num")
    public ApiResult<MessageNumResp> messageNum() {
        return ApiResult.successWithResult(portalMockService.getMessageNum(null));
    }

    /**
     * 消息列表查询
     *
     * @param req
     * @return
     */
    @PostMapping("/message/page")
    public ApiResult<BasePageResp<Object>> messagePage(@RequestBody @Validated MessagePageReq req) {
        int curUserId = 1;
        return ApiResult.successWithResult(portalMockService.pageMessageNum(req));
    }

}
