package com.cnooc.expert.controller.subject;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.subject.model.request.CompanyPageReq;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.subject.model.response.PlatformCompanyPageApiResp;
import com.cnooc.expert.service.subject.SubjectService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/subject")
public class SubjectController extends AbstractBaseController {

    private final SubjectService subjectService;

    /**
     * 公司列表 / 回避单位
     *
     * @return
     */
    @PostMapping("/company/page")
    public ApiResult<ApiBasePageResp<PlatformCompanyPageApiResp>> companyPage(@RequestBody @Validated CompanyPageReq req) {
        ApiBasePageResp<PlatformCompanyPageApiResp> apiResp = subjectService.pageCompany(req);
        return ApiResult.successWithResult(apiResp);
    }

}
