package com.cnooc.expert.external.pingbiao.service;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.pingbiao.api.PingBiaoServiceApi;
import com.cnooc.expert.external.pingbiao.model.request.SignOptimizeReq;
import com.cnooc.expert.external.pingbiao.model.response.FaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.IdentifyFaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.SignValidityPeriodResp;
import com.cnooc.expert.external.pingbiao.model.response.WhitelistStatusResp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Map;

@Service
public class PingBiaoServiceClient extends AbstractRetrofitManager {
    private final PingBiaoServiceApi pingBiaoServiceApi;

    public PingBiaoServiceClient(@Qualifier("retrofitPingBiao") Retrofit retrofit) {
        this.pingBiaoServiceApi = retrofit.create(PingBiaoServiceApi.class);
    }

    public ApiBaseResult<SignValidityPeriodResp> getSignValidityPeriod(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<SignValidityPeriodResp>> call = pingBiaoServiceApi.getSignValidityPeriod(headers,request);
        return this.getResponseBody(call, "getSignValidityPeriod");
    }

    public ApiBaseResult<WhitelistStatusResp> queryInsideSignUser(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<WhitelistStatusResp>> call = pingBiaoServiceApi.queryInsideSignUser(headers,request);
        return this.getResponseBody(call, "queryInsideSignUser");
    }

    public ApiBaseResult<WhitelistStatusResp> queryOutsidePerson(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<WhitelistStatusResp>> call = pingBiaoServiceApi.queryOutsidePerson(headers,request);
        return this.getResponseBody(call, "queryOutsidePerson");
    }

    public ApiBaseResult<WhitelistStatusResp> createOutsidePerson(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<WhitelistStatusResp>> call = pingBiaoServiceApi.createOutsidePerson(headers,request);
        return this.getResponseBody(call, "createOutsidePerson");
    }

    public ApiBaseResult<FaceDynResp> getFaceDyn(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<FaceDynResp>> call = pingBiaoServiceApi.getFaceDyn(headers,request);
        return this.getResponseBody(call, "getFaceDyn");
    }

    public ApiBaseResult<IdentifyFaceDynResp> identifyFaceDyn(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<IdentifyFaceDynResp>> call = pingBiaoServiceApi.identifyFaceDyn(headers,request);
        return this.getResponseBody(call, "identifyFaceDyn");
    }

    public ApiBaseResult<WhitelistStatusResp> sendSceneCode(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<WhitelistStatusResp>> call = pingBiaoServiceApi.sendSceneCode(headers,request);
        return this.getResponseBody(call, "sendSceneCode");
    }

    public ApiBaseResult<WhitelistStatusResp> validSceneCode(SignOptimizeReq request) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<WhitelistStatusResp>> call = pingBiaoServiceApi.validSceneCode(headers,request);
        return this.getResponseBody(call, "validSceneCode");
    }
}
