/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server;

import com.wangyin.key.server.exception.AuthException;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.DigestAlgEnum;
import com.wangyin.key.server.model.Key;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.model.PayCode;
import com.wangyin.key.server.model.RadixEnum;
import com.wangyin.key.server.model.Session;
import com.wangyin.key.server.util.AKSCertInfo;
import java.util.List;
import java.util.Map;

public interface IBaseCryptoService {
    public String login(String var1, String var2) throws AuthException;

    public String loginCert(String var1, String var2) throws AuthException;

    public void logout(String var1) throws AuthException;

    public void createKey(Session var1, Key var2, String var3) throws KeyException;

    public byte[] getKey(String var1, String var2, String var3) throws KeyException;

    public byte[] getPwd(String var1, String var2, String var3) throws KeyException;

    public List<byte[]> deP7envelop(String var1, String var2, String var3, String var4) throws KeyException;

    public List<Key> getAliasList(String var1, String var2) throws AuthException;

    public String autoReqRegist(String var1, String var2) throws AuthException;

    public String setPayStatus(PayCode var1) throws KeyException;

    public String getPayStatus(PayCode var1) throws KeyException;

    public String createUserSeed(PayCode var1) throws KeyException;

    public String checkQRcode(PayCode var1) throws KeyException;

    public String getQRcode(PayCode var1) throws KeyException;

    public String getPaymentcode(PayCode var1) throws KeyException;

    public Boolean sendStatus(String var1, String var2) throws AuthException;

    public Session init(String var1, String var2) throws AuthException;

    public String getOfflineStatus(String var1, String var2) throws AuthException;

    public String getServerPolicy(String var1, String var2) throws AuthException;

    public byte[] private_decrypt(String var1, String var2, String var3, byte[] var4) throws KeyException;

    public byte[] public_encrypt(String var1, String var2, String var3, byte[] var4, byte[] var5) throws KeyException;

    public byte[] private_encrypt(String var1, String var2, String var3, byte[] var4) throws KeyException;

    public byte[] public_decrypt(String var1, String var2, String var3, byte[] var4, byte[] var5) throws KeyException;

    public byte[] p1Sign(String var1, String var2, String var3, byte[] var4) throws KeyException;

    public boolean p1Verify(String var1, String var2, String var3, byte[] var4, byte[] var5, byte[] var6) throws KeyException;

    public byte[] encrypt(String var1, String var2, String var3, ModeEnum var4, PaddingEnum var5, byte[] var6, byte[] var7) throws KeyException;

    public byte[] encryptByVersion(String var1, String var2, String var3, ModeEnum var4, PaddingEnum var5, byte[] var6) throws KeyException;

    public byte[] decrypt(String var1, String var2, String var3, ModeEnum var4, PaddingEnum var5, byte[] var6, byte[] var7) throws KeyException;

    public byte[] decryptByVersion(String var1, String var2, String var3, ModeEnum var4, PaddingEnum var5, byte[] var6, byte[] var7) throws KeyException;

    public String encryptFF1(String var1, String var2, String var3, RadixEnum var4, String var5, String var6) throws KeyException;

    public String decryptFF1(String var1, String var2, String var3, RadixEnum var4, String var5, String var6) throws KeyException;

    public Boolean setNewBankZPK(String var1, String var2, String var3, String var4, String var5, String var6) throws KeyException;

    public Boolean setNewBankZAK(String var1, String var2, String var3, String var4, String var5, String var6) throws KeyException;

    public String calculateMAC(String var1, String var2, String var3, String var4, String var5) throws KeyException;

    public Boolean verifyMAC(String var1, String var2, String var3, String var4, String var5, String var6) throws KeyException;

    public String decryptoPW(String var1, String var2, String var3, String var4, String var5, String var6) throws KeyException;

    public String getRSAPublicKeyN(String var1, String var2, String var3) throws KeyException;

    public List<String> getRSAPrivateKey(String var1, String var2, String var3, String var4) throws KeyException;

    public List<String> encryptUserPwd(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws KeyException;

    public String verifyUserPwd(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws KeyException;

    public byte[] decryptoAKSWebData(String var1, String var2, String var3, String var4, String var5, String var6, AlgEnum var7, ModeEnum var8, PaddingEnum var9, byte[] var10, String var11) throws KeyException;

    public byte[] encryptoAKSWebData(String var1, String var2, String var3, String var4, String var5, AlgEnum var6, ModeEnum var7, PaddingEnum var8, byte[] var9, String var10, byte[] var11) throws KeyException;

    public String decryptUserID(PayCode var1) throws KeyException;

    public List<String> createUserSeedByJDPin(PayCode var1) throws KeyException;

    public String deleteSeedByJDPin(PayCode var1) throws KeyException;

    public String checkPaymentcode(PayCode var1) throws KeyException;

    public String encryptSignedEnvelop(String var1, String var2, String var3, byte[] var4, byte[] var5) throws KeyException;

    public String exportCert(String var1, String var2, String var3) throws KeyException;

    public String p7Sign(String var1, String var2, String var3, boolean var4, byte[] var5) throws KeyException;

    public void pubPayCodeInfo(String var1, String var2, String var3, String var4, String var5) throws KeyException;

    public List<String> cleanPW(String var1, String var2, String var3, String var4, String var5) throws KeyException;

    public boolean removePW(String var1, String var2, String var3) throws KeyException;

    public List<String> resetPWAks(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws KeyException;

    public List<String> checkPWAks(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10) throws KeyException;

    public List<String> resetPWMD5(String var1, String var2, String var3, String var4, String var5, String var6) throws KeyException;

    public String checkPWMD5(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9) throws KeyException;

    public List<String> encryptEvpWithSymm(String var1, String var2, String var3, String var4, AlgEnum var5, ModeEnum var6, PaddingEnum var7, String var8, byte[] var9) throws KeyException;

    public byte[] decryptEvpWithSymm(String var1, String var2, String var3, AlgEnum var4, ModeEnum var5, PaddingEnum var6, String var7, byte[] var8, byte[] var9) throws KeyException;

    public List<String> p7Verify(String var1, String var2, String var3, boolean var4, String var5, byte[] var6) throws KeyException;

    public String encryptEnvelop(String var1, String var2, String var3, byte[] var4, byte[] var5) throws KeyException;

    public String decryptEnvelop(String var1, String var2, String var3, String var4) throws KeyException;

    public String convertEncrypt(String var1, String var2, String var3, String var4, ModeEnum var5, PaddingEnum var6, byte[] var7, String var8, ModeEnum var9, PaddingEnum var10, byte[] var11, String var12) throws KeyException;

    public boolean compareCiphertext(String var1, String var2, String var3, String var4, ModeEnum var5, PaddingEnum var6, byte[] var7, String var8, String var9, ModeEnum var10, PaddingEnum var11, byte[] var12, String var13) throws KeyException;

    public Map<String, Boolean> antiCheatForSdk(String var1, String var2, String var3) throws KeyException;

    public String getSoftTokenSeed(String var1, String var2, String var3) throws KeyException;

    public String deleteSoftTokenSeed(String var1, String var2, String var3) throws KeyException;

    public String checkSoftToken(String var1, String var2, String var3, String var4) throws KeyException;

    public String checkSoftTokenOTP(String var1, String var2, String var3, String var4) throws KeyException;

    public List<Key> getAuthorizedKeys(String var1, String var2);

    public String initPasswordForE2E(String var1, String var2, String var3, String[] var4) throws KeyException;

    public String validatePasswordForE2E(String var1, String var2, String var3, String var4) throws KeyException;

    public String updatePasswordForE2E(String var1, String var2, String var3, String var4, String var5, String[] var6) throws KeyException;

    public List<String> getRootCert(String var1, String var2);

    public String indexing(String var1, String var2, byte[] var3) throws KeyException;

    public byte[] crypto(boolean var1, AlgEnum var2, ModeEnum var3, PaddingEnum var4, byte[] var5, byte[] var6, byte[] var7) throws KeyException;

    public String antiRush(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, int var10, int var11) throws KeyException;

    public byte[] hash(String var1, String var2, DigestAlgEnum var3, byte[] var4) throws KeyException;

    public AKSCertInfo getCertInfo(String var1, String var2, String var3) throws KeyException;

    public byte[] checkForGeneralKeyboard(String var1, String var2, String var3, String var4, String var5, boolean var6) throws KeyException;

    public String antiRush2JS(String var1, String var2, String var3, String var4, String var5) throws KeyException;

    public String antiRush2(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, int var10, int var11) throws KeyException;

    public String getKeyAliasFromCipherText(String var1, String var2, String var3) throws KeyException;

    public void report(String var1) throws KeyException;
}

