/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.hsm;

import com.wangyin.key.server.exception.BaseException;
import com.wangyin.key.server.hsm.IDataHandler;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.CertCache;
import com.wangyin.key.server.model.Key;
import com.wangyin.key.server.model.Session;
import com.wangyin.key.server.model.UserEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmDataHandler
extends IDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HsmDataHandler.class);
    private static String appId = null;
    private static String hsmsysZkaddress = null;
    private static String hsmsysAddress = null;
    private static int hsmsysTimeout = 5000;
    private List<String> hsmsystems = null;

    public HsmDataHandler(String zkaddress, int timeout, String appid) throws BaseException {
        appId = appid;
        hsmsysZkaddress = zkaddress;
        hsmsysTimeout = timeout;
        this.getHsmIPs();
        this.connectAndShakehands();
    }

    private void getHsmIPs() throws BaseException {
        try {
            CuratorFramework client = CuratorFrameworkFactory.newClient((String)hsmsysZkaddress, (int)hsmsysTimeout, (int)hsmsysTimeout, (RetryPolicy)new RetryNTimes(3, 5000));
            client.start();
            this.hsmsystems = (List)client.getChildren().forPath("/AKS/aks-hsmsys/addr");
            client.close();
        }
        catch (Exception e) {
            throw new BaseException("hsm_error", " connect to zk has error! ");
        }
        if (this.hsmsystems == null || this.hsmsystems.size() == 0) {
            LOGGER.error("get hsm server ip from zk has error!");
            throw new BaseException("hsm", "get hsm server ip from zk has error!");
        }
    }

    private void connectAndShakehands() throws BaseException {
        StringBuilder addr = new StringBuilder();
        for (int i = 0; i < this.hsmsystems.size(); ++i) {
            String ip_port = this.hsmsystems.get(i).replace("_", ":");
            if (!ip_port.contains(":")) {
                ip_port = this.hsmsystems.get(i) + ":20004";
            }
            addr.append(ip_port);
            if (i >= this.hsmsystems.size() - 1) continue;
            addr.append("|");
        }
        hsmsysAddress = addr.toString();
    }

    @Override
    public Session initSession(Session session) throws BaseException {
        try {
            ArrayList<String> aliasList = new ArrayList<String>();
            String token = AKSNativeCryptoService.loginHsmsys(appId, hsmsysAddress, hsmsysTimeout, aliasList);
            session.setOptName(appId);
            session.setOptPwd("");
            session.setToken(token);
            session.setUserType(UserEnum.DEV_CRYPTO);
            session.setStatus("Y");
            ArrayList<Key> keys = new ArrayList<Key>();
            for (String alias : aliasList) {
                Key key = new Key();
                key.setAlias(alias);
                key.setUseType(0);
                key.setToken(token);
                keys.add(key);
            }
            session.setAliases(keys);
            session.setServerVersion("offline");
        }
        catch (Exception e) {
            LOGGER.error("initSession has error!", (Throwable)e);
            throw new BaseException("hsm", "initSession has error!" + e.getMessage());
        }
        return session;
    }

    @Override
    public void getKeysR6(Session session, List<String> aliasList, List<CertCache> certs) throws BaseException {
        try {
            AKSNativeCryptoService.getAndPutKeysByHsmsys(session.getOptName(), aliasList, certs);
        }
        catch (Exception e) {
            LOGGER.error("handleR6 has error!", (Throwable)e);
            throw new BaseException("hsm", "handleR6 has error!" + e.getMessage());
        }
    }
}

