/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.util.AKSCertInfo;
import com.wangyin.key.server.util.ByteUtil;
import com.wangyin.key.server.util.CryptUtil;
import com.wangyin.key.server.util.DatatypeConverter;
import com.wangyin.key.server.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKIHelper.class);

    public static AKSCertInfo getCertInfo(byte[] cert) {
        X509Certificate x509Cert = PKIHelper.parseCert(cert);
        if (x509Cert != null) {
            AKSCertInfo certInfo = new AKSCertInfo();
            Date currentTime = new Date();
            try {
                certInfo.setCertB64(DatatypeConverter.printBase64Binary(x509Cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("getCertInfo CertificateEncodingException");
            }
            certInfo.setCertDN(x509Cert.getSubjectDN().getName());
            byte[] bsSN = x509Cert.getSerialNumber().toByteArray();
            String sn = ByteUtil.bytesToHexString(bsSN).toUpperCase();
            certInfo.setCertSN(sn);
            certInfo.setCertIDN(x509Cert.getIssuerDN().getName());
            certInfo.setCertResidualTime((x509Cert.getNotAfter().getTime() - currentTime.getTime()) / 1000L / 3600L / 24L);
            return certInfo;
        }
        throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
    }

    public static X509Certificate parseCert(byte[] cert) {
        ByteArrayInputStream in = PKIHelper.certToInput(cert);
        if (in != null) {
            try {
                CertificateFactory x509Cert_factory = CertificateFactory.getInstance("X.509");
                return (X509Certificate)x509Cert_factory.generateCertificate(in);
            }
            catch (CertificateException e) {
                try {
                    in = PKIHelper.certToInput(cert);
                    CertificateFactory x509Cert_factory = CertificateFactory.getInstance("X.509", "BC");
                    return (X509Certificate)x509Cert_factory.generateCertificate(in);
                }
                catch (Exception e1) {
                    LOGGER.warn("X509\u8bc1\u4e66\u521d\u59cb\u5316\u5931\u8d25, cert is {}", (Object)DatatypeConverter.printBase64Binary(cert));
                }
            }
        }
        return null;
    }

    private static ByteArrayInputStream certToInput(byte[] cert) {
        if (cert != null) {
            try {
                String certStr = new String(cert, "UTF-8");
                ByteArrayInputStream in = certStr.startsWith("-----BEGIN CERTIFICATE-----") && certStr.endsWith("-----END CERTIFICATE-----") || certStr.startsWith("-----BEGIN X509 CERTIFICATE-----") && certStr.endsWith("-----END X509 CERTIFICATE-----") || !StringUtil.isBase64(cert) ? new ByteArrayInputStream(cert) : new ByteArrayInputStream(DatatypeConverter.parseBase64Binary(certStr));
                return in;
            }
            catch (Exception e) {
                LOGGER.warn("certToInputStream error, cert is {}", (Object)DatatypeConverter.printBase64Binary(cert));
            }
        }
        return null;
    }

    public static boolean certIsExpire(byte[] cert) {
        return PKIHelper.certIsExpire(PKIHelper.parseCert(cert));
    }

    public static boolean certIsExpire(X509Certificate x509Cert) {
        if (x509Cert == null) {
            return true;
        }
        long expireTime = x509Cert.getNotAfter().getTime();
        long currentTime = new Date().getTime();
        return currentTime > expireTime;
    }

    public static String getPubKeyStringForSM2(String aliasName, byte[] cert) {
        byte[] pubKey = PKIHelper.getPubKeyForSM2(cert);
        ByteBuffer byteBuffer = ByteBuffer.allocate(9 + pubKey.length);
        byteBuffer.put(new byte[]{1, 19, 0});
        byteBuffer.put(aliasName.replace("_13_", "").getBytes());
        byteBuffer.put(pubKey);
        return DatatypeConverter.printBase64Binary(byteBuffer.array());
    }

    public static byte[] getPubKeyForSM2(byte[] cert) {
        try {
            X509Certificate x509Certificate = PKIHelper.parseCert(cert);
            ByteArrayInputStream inStream = new ByteArrayInputStream(x509Certificate.getPublicKey().getEncoded());
            ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)inStream);
            ASN1Sequence asn1Sequence = (ASN1Sequence)asn1InputStream.readObject();
            DERBitString derBitString = (DERBitString)asn1Sequence.getObjectAt(1);
            return derBitString.getOctets();
        }
        catch (Exception e) {
            LOGGER.warn("getPubKeyForSM2 error, cert is {}", (Object)DatatypeConverter.printBase64Binary(cert));
            throw new KeyException(AksExceptionEnum.AKS_99_00089.getCode(), AksExceptionEnum.AKS_99_00089.getDesc() + e.toString() + e.getMessage());
        }
    }

    public static byte[][] parseSMWebData(String data) {
        try {
            byte[][] result = new byte[4][];
            byte[] cipherText = DatatypeConverter.parseBase64Binary(data);
            byte version = cipherText[0];
            if (version != 1 || cipherText.length < 137) {
                LOGGER.warn("parseSMWebData error, data is {}", (Object)data);
                throw new KeyException(AksExceptionEnum.AKS_99_00057.getCode(), AksExceptionEnum.AKS_99_00057.getDesc() + data);
            }
            byte[] alias = new byte[6];
            System.arraycopy(cipherText, 3, alias, 0, alias.length);
            result[0] = alias;
            byte[] c1 = new byte[64];
            System.arraycopy(cipherText, 9, c1, 0, c1.length);
            byte[] c3 = new byte[32];
            System.arraycopy(cipherText, c1.length + 9, c3, 0, c3.length);
            byte[] c2 = new byte[16];
            System.arraycopy(cipherText, c1.length + c3.length + 9, c2, 0, c2.length);
            byte[] iv = new byte[16];
            System.arraycopy(cipherText, 121, iv, 0, iv.length);
            result[1] = iv;
            byte[] sm4 = new byte[cipherText.length - 137];
            System.arraycopy(cipherText, 137, sm4, 0, sm4.length);
            result[2] = sm4;
            BigInteger bigInteger1 = BigIntegers.fromUnsignedByteArray((byte[])c1, (int)0, (int)32);
            BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])c1, (int)32, (int)32);
            ASN1Integer cc11 = new ASN1Integer(bigInteger1);
            ASN1Integer cc12 = new ASN1Integer(bigInteger2);
            DEROctetString cc2 = new DEROctetString(c2);
            DEROctetString cc3 = new DEROctetString(c3);
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)cc11);
            vector.add((ASN1Encodable)cc12);
            vector.add((ASN1Encodable)cc3);
            vector.add((ASN1Encodable)cc2);
            result[3] = new DERSequence(vector).getEncoded();
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("parseSMWebData error, data is {}", (Object)data, (Object)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00057.getCode(), AksExceptionEnum.AKS_99_00057.getDesc() + data);
        }
    }

    public static byte[][] parseSMKeyboardData(String data) {
        try {
            byte[][] result = new byte[3][];
            byte[] cipherText = DatatypeConverter.parseBase64Binary(data);
            if (cipherText.length < 128) {
                LOGGER.warn("parseSMKeyboardData error, data is {}", (Object)data);
                throw new KeyException(AksExceptionEnum.AKS_99_00090.getCode(), AksExceptionEnum.AKS_99_00090.getDesc() + data);
            }
            byte[] c1 = new byte[64];
            System.arraycopy(cipherText, 0, c1, 0, c1.length);
            byte[] c3 = new byte[32];
            System.arraycopy(cipherText, c1.length, c3, 0, c3.length);
            byte[] c2 = new byte[16];
            System.arraycopy(cipherText, c1.length + c3.length, c2, 0, c2.length);
            byte[] iv = new byte[16];
            System.arraycopy(cipherText, 112, iv, 0, iv.length);
            result[0] = iv;
            byte[] sm4 = new byte[cipherText.length - 128];
            System.arraycopy(cipherText, 128, sm4, 0, sm4.length);
            result[1] = sm4;
            BigInteger bigInteger1 = BigIntegers.fromUnsignedByteArray((byte[])c1, (int)0, (int)32);
            BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray((byte[])c1, (int)32, (int)32);
            ASN1Integer cc11 = new ASN1Integer(bigInteger1);
            ASN1Integer cc12 = new ASN1Integer(bigInteger2);
            DEROctetString cc2 = new DEROctetString(c2);
            DEROctetString cc3 = new DEROctetString(c3);
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)cc11);
            vector.add((ASN1Encodable)cc12);
            vector.add((ASN1Encodable)cc3);
            vector.add((ASN1Encodable)cc2);
            result[2] = new DERSequence(vector).getEncoded();
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("parseSMKeyboardData error, data is {}", (Object)data, (Object)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00090.getCode(), AksExceptionEnum.AKS_99_00090.getDesc() + data);
        }
    }

    public static Cipher getCipherBC(AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        return Cipher.getInstance(CryptUtil.getAlgorithmString(algEnum, modeEnum, paddingEnum), "BC");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

