/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.crypto;

import com.jd.jr.aks.security.configuration.EnvMode;
import com.jd.jr.aks.security.crypto.AesCipher;
import com.jd.jr.aks.security.crypto.Decryption;
import com.jd.jr.aks.security.crypto.DonothingCipher;
import com.jd.jr.aks.security.crypto.aks.AksDevCipher;
import com.jd.jr.aks.security.crypto.aks.AksProCipher;
import com.jd.jr.aks.security.crypto.aks.AksTestCipher;
import com.jd.jr.aks.security.crypto.paks.PAksDevCipher;
import com.jd.jr.aks.security.crypto.paks.PAksProCipher;
import com.jd.jr.aks.security.monitor.MonitorMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CipherFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CipherFactory.class.getName());
    private static Decryption instance;

    public static synchronized Decryption getInstance() {
        if (instance == null) {
            EnvMode envMode = EnvMode.get();
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS\u5c06\u4ee5" + envMode.name() + "\u6a21\u5f0f\u542f\u52a8.");
            MonitorMessageBuilder.initClient();
            switch (envMode) {
                case OFF: {
                    instance = new DonothingCipher();
                    break;
                }
                case LOCAL: {
                    instance = new AesCipher();
                    break;
                }
                case DEV: {
                    instance = new AksDevCipher();
                    break;
                }
                case TEST: {
                    instance = new AksTestCipher();
                    break;
                }
                default: {
                    instance = new AksProCipher();
                    break;
                }
                case P_DEV: {
                    instance = new PAksDevCipher();
                    break;
                }
                case P_PRO: {
                    instance = new PAksProCipher();
                }
            }
        }
        return instance;
    }
}

