/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.monitor;

import com.jd.jr.aks.security.monitor.HttpClient;
import com.jd.jr.aks.security.utils.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FMQClient {
    private static final String PROXY_TEMP = "http://%s/1.0/%s";
    private final ExecutorService pool = new ThreadPoolExecutor(1, 4, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2048), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock rLock = this.lock.readLock();
    private final Lock wLock = this.lock.writeLock();
    private String proxy = "fmq-proxy.jdfin.local";
    private String app = "AksConfigSecurity";
    private String password = "A47B8907";
    private String topic = "aks_config_security";
    private String token;
    private List<String> servers;

    FMQClient() {
        String proxy = System.getProperty("aks.acs.fmq.proxy");
        String app = System.getProperty("aks.acs.fmq.app");
        String password = System.getProperty("aks.acs.fmq.password");
        String topic = System.getProperty("aks.acs.fmq.topic");
        if (proxy != null && app != null && password != null && topic != null) {
            this.proxy = proxy;
            this.app = app;
            this.password = password;
            this.topic = topic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auth() {
        if (this.wLock.tryLock()) {
            try {
                String url = String.format(PROXY_TEMP, this.proxy, "auth");
                AuthResponse response = HttpClient.post(url, this.buildHeaders(null), null, JSON.toJSONString(new AuthRequest(this.app, this.password, this.topic)), AuthResponse.class);
                if (response == null || response.getStatus() == null || response.getStatus().getCode() != 0 || response.getResult() == null) {
                    return;
                }
                this.servers = response.getResult().getServers();
                this.token = response.getResult().getToken();
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    void produce(String text) {
        this.pool.submit(new SendRunner(this, text));
    }

    void produce0(String text) {
        String url = String.format(PROXY_TEMP, this.pick(), "produce");
        AuthResponse response = HttpClient.post(url, this.buildHeaders(this.token), null, JSON.toJSONString(new ProduceRequest(this.app, this.topic, text)), AuthResponse.class);
        if (response == null || response.getStatus() == null || response.getStatus().getCode() != 0) {
            this.auth();
            url = String.format(PROXY_TEMP, this.pick(), "produce");
            HttpClient.post(url, this.buildHeaders(this.token), null, JSON.toJSONString(new ProduceRequest(this.app, this.topic, text)), AuthResponse.class);
        }
    }

    private Map<String, String> buildHeaders(String token) {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put("User-Agent", "FMQ-JAVA");
        headers.put("Accept", "text/plain");
        headers.put("Host", "fmq-proxy.jdfin.local");
        headers.put("Timestamp", "" + System.currentTimeMillis());
        if (token != null) {
            headers.put("Token", token);
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pick() {
        int retry = 3;
        while (--retry > 0) {
            this.rLock.lock();
            try {
                if (this.servers != null && !this.servers.isEmpty()) {
                    break;
                }
            }
            finally {
                this.rLock.unlock();
            }
            this.auth();
        }
        this.rLock.lock();
        try {
            if (this.servers == null || this.servers.isEmpty()) {
                String string = null;
                return string;
            }
            int i = MyThreadLocalRandom.current().nextInt(this.servers.size());
            String string = this.servers.get(i);
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    static class SendRunner
    implements Runnable {
        private final FMQClient client;
        private final String text;

        public SendRunner(FMQClient client, String text) {
            this.client = client;
            this.text = text;
        }

        @Override
        public void run() {
            this.client.produce0(this.text);
        }
    }

    static class MyThreadLocalRandom {
        private static final ThreadLocal<Random> Randoms = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random();
            }
        };

        MyThreadLocalRandom() {
        }

        static Random current() {
            return Randoms.get();
        }
    }

    static class Messages {
        private String businessId = "default";
        private String text;

        public Messages() {
        }

        public Messages(String text) {
            this.text = text;
        }

        public String getBusinessId() {
            return this.businessId;
        }

        public void setBusinessId(String businessId) {
            this.businessId = businessId;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    static class ProduceRequest {
        private String app;
        private String topic;
        private List<Messages> messages = new ArrayList<Messages>();

        public ProduceRequest() {
        }

        public ProduceRequest(String app, String topic, String text) {
            this.app = app;
            this.topic = topic;
            this.messages.add(new Messages(text));
        }

        public String getApp() {
            return this.app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public List<Messages> getMessages() {
            return this.messages;
        }

        public void setMessages(List<Messages> messages) {
            this.messages = messages;
        }

        public void msg(String text) {
            this.messages.add(new Messages(text));
        }
    }

    static class Result {
        private List<String> servers;
        private String token;

        Result() {
        }

        public List<String> getServers() {
            return this.servers;
        }

        public void setServers(List<String> servers) {
            this.servers = servers;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String toString() {
            return "Result{servers=" + this.servers + ", token='" + this.token + '\'' + '}';
        }
    }

    static class Status {
        private int code;
        private String msg;

        Status() {
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }

    static class AuthResponse {
        private Status status;
        private Result result;

        AuthResponse() {
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public String toString() {
            return "AuthResponse{status=" + this.status + ", result=" + this.result + '}';
        }
    }

    static class AuthRequest {
        private String app;
        private String password;
        private String topic;

        public AuthRequest(String app, String password, String topic) {
            this.app = app;
            this.password = password;
            this.topic = topic;
        }

        public String getApp() {
            return this.app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }
    }
}

