package com.cnooc.expert.controller.pingbiao;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.external.pingbiao.model.request.SignOptimizeReq;
import com.cnooc.expert.external.pingbiao.model.response.FaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.IdentifyFaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.SignValidityPeriodResp;
import com.cnooc.expert.external.pingbiao.model.response.WhitelistStatusResp;
import com.cnooc.expert.service.PingBiaoService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/pingbiao")
public class PingBiaoController extends AbstractBaseController {

    private final PingBiaoService pingBiaoService;

    //查询证书预授权有效期
    @PostMapping("/getSignValidityPeriod")
    public ApiResult<SignValidityPeriodResp> getSignValidityPeriod(@RequestBody SignOptimizeReq signOptimizeDto){
        return ApiResult.successWithResult(pingBiaoService.getSignValidityPeriod(signOptimizeDto));
    }

    //查询内部用户白名单状态
    @PostMapping("/queryInsideSignUser")
    public ApiResult<WhitelistStatusResp> queryInsideSignUser(@RequestBody SignOptimizeReq signOptimizeDto) {
        return ApiResult.successWithResult(pingBiaoService.queryInsideSignUser(signOptimizeDto));
    }

    //查询外部用户白名单状态
    @PostMapping("/queryOutsidePerson")
    public ApiResult<WhitelistStatusResp> queryOutsidePerson(@RequestBody SignOptimizeReq signOptimizeDto) {
        return ApiResult.successWithResult(pingBiaoService.queryOutsidePerson(signOptimizeDto));
    }

    //创建外部用户白名单状态
    @PostMapping("/createOutsidePerson")
    public ApiResult<WhitelistStatusResp> createOutsidePerson(@RequestBody SignOptimizeReq signOptimizeDto) {
        return ApiResult.successWithResult(pingBiaoService.createOutsidePerson(signOptimizeDto));
    }

    //人脸识别-动态
    @PostMapping("/getFaceDyn")
    public ApiResult<FaceDynResp> getFaceDyn(@RequestBody SignOptimizeReq signOptimizeDto){
        return ApiResult.successWithResult(pingBiaoService.getFaceDyn(signOptimizeDto));
    }

    //获取动态人脸识别核验结果
    @PostMapping("/identifyFaceDyn")
    public ApiResult<IdentifyFaceDynResp> identifyFaceDyn(@RequestBody SignOptimizeReq signOptimizeDto){
        return ApiResult.successWithResult(pingBiaoService.identifyFaceDyn(signOptimizeDto));
    }

    //场景证书授权人发送授权码
    @PostMapping("/sendSceneCode")
    public ApiResult<WhitelistStatusResp> sendSceneCode(@RequestBody SignOptimizeReq signOptimizeDto){
        return ApiResult.successWithResult(pingBiaoService.sendSceneCode(signOptimizeDto));
    }

    //验证场景证书授权码
    @PostMapping("/validSceneCode")
    public ApiResult<WhitelistStatusResp> validSceneCode(@RequestBody SignOptimizeReq signOptimizeDto){
        return ApiResult.successWithResult(pingBiaoService.validSceneCode(signOptimizeDto));
    }
}
