package com.cnooc.expert.controller.workflow;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingByConditionGetReq;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingByConditionGetResp;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingPageResp;
import com.cnooc.expert.controller.workflow.model.response.InstCalculateResp;
import com.cnooc.expert.controller.workflow.model.response.InstStartResp;
import com.cnooc.expert.controller.workflow.model.response.ReceiveSettingByConditionFindResp;
import com.cnooc.expert.external.workflow.model.request.ApprovePathSettingByConditionGetApiReq;
import com.cnooc.expert.external.workflow.model.request.ApprovePathSettingSaveOrUpdateApiReq;
import com.cnooc.expert.external.workflow.model.request.InstCalculateApiReq;
import com.cnooc.expert.external.workflow.model.request.InstExistedQueryApiReq;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.request.StageDetailShowApiReq;
import com.cnooc.expert.external.workflow.model.response.StageDetailShowApiResp;
import com.cnooc.expert.service.workflow.WorkflowMockService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/mock/workflow")
public class WorkflowMockController extends AbstractBaseController {

    private final WorkflowMockService workflowMockService;

    // 流程实例启动
    @PostMapping("/start")
    public ApiResult<InstStartResp> instStart(@RequestBody @Validated InstStartApiReq req) {
        InstStartResp apiResp = workflowMockService.startInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 流程实例回撤
    @PostMapping("/revoke")
    public ApiResult<Boolean> instRevoke(@RequestBody @Validated InstRevokeApiReq req) {
        Boolean apiResp = workflowMockService.revokeInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 获取审批路径
    @PostMapping("/findDefInfoListByCondition")
    public ApiResult<BasePageResp<ApprovePathSettingPageResp>> pageApprovePathSetting(@RequestBody @Validated ApprovePathSettingPageReq req) {
        return ApiResult.successWithResult(workflowMockService.pageApprovePathSetting(req));
    }

    // 计算是否需要审批, 需要审批返回能使用的模板信息
    @PostMapping("/inst/calculate")
    public ApiResult<InstCalculateResp> instCalculate(@RequestBody @Validated InstCalculateApiReq req) {
        InstCalculateResp apiResp = workflowMockService.calculateInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 保存、编辑审批路径配置
    @PostMapping("/saveOrUpdateApprovePathSetting")
    public ApiResult<Object> saveOrUpdateApprovePathSetting(@RequestBody @Validated ApprovePathSettingSaveOrUpdateApiReq req) {
        workflowMockService.saveOrUpdateApprovePathSetting(req);
        return ApiResult.success();
    }

    // 获取审批模版
    @PostMapping("/getApprovePathSettingByCondition")
    public ApiResult<ApprovePathSettingByConditionGetResp> saveOrUpdateApprovePathSetting(@RequestBody @Validated ApprovePathSettingByConditionGetApiReq req) {
        ApprovePathSettingByConditionGetResp apiResp = workflowMockService.getApprovePathSettingByCondition(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 查询限上岗配置 - 没数据表示不需要配置限上岗"
    @PostMapping("/fingReceiveSettingByCondition")
    public ApiResult<List<ReceiveSettingByConditionFindResp>> fingReceiveSettingByCondition(@RequestBody @Validated ApprovePathSettingByConditionGetReq req) {
        List<ReceiveSettingByConditionFindResp> apiResp = workflowMockService.findReceiveSettingByCondition(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 查询是否存在流程实例对象
    @PostMapping("/inst/qryInstExisted")
    public ApiResult<Boolean> queryInstExisted(@RequestBody @Validated InstExistedQueryApiReq req) {
        Boolean apiResp = workflowMockService.queryInstExisted(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 发起人,我的申请页面, 审批流程需要展示的阶段(含详情)<二选一>
    @PostMapping("/inst/showStageDetail")
    public ApiResult<List<StageDetailShowApiResp>> queryInstExisted(@RequestBody @Validated StageDetailShowApiReq req) {
        List<StageDetailShowApiResp> apiResp = workflowMockService.showStageDetail(req);
        return ApiResult.successWithResult(apiResp);
    }

}
