package com.cnooc.expert.service.auth;

import com.cnooc.expert.controller.auth.model.response.SlideCaptchaVO;
import com.cnooc.expert.system.entity.vo.SysCaptchaVO;

public interface SysCaptchaService {
    /**
     * 生成验证码
     * @return 验证码captcha vo
     */
    SysCaptchaVO generate();

    SlideCaptchaVO generateSlide();
    /**
     * 验证码效验
     *
     * @param key  key
     * @param code 验证码
     * @return true：成功  false：失败
     */
    boolean validate(String key, String code);

    boolean validateSlide(String code, Integer moveX);

    /**
     * 是否开启登录验证码
     *
     * @return true：开启  false：关闭
     */
    boolean isCaptchaEnabled();
}
