package com.cnooc.expert.service.portal;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.portal.model.request.AgentNumReq;
import com.cnooc.expert.controller.portal.model.request.AgentPageReq;
import com.cnooc.expert.controller.portal.model.request.MessageNumReq;
import com.cnooc.expert.controller.portal.model.request.MessagePageReq;
import com.cnooc.expert.controller.portal.model.response.AgentNumResp;
import com.cnooc.expert.controller.portal.model.response.AgentPageResp;
import com.cnooc.expert.controller.portal.model.response.MessageNumResp;
import com.cnooc.expert.controller.portal.model.response.MessagePageResp;
import com.cnooc.expert.external.portal.service.PortalServiceClient;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@AllArgsConstructor
@Service
public class PortalMockService {

    private final PortalServiceClient portalServiceClient;

    public AgentNumResp getAgentNum(AgentNumReq req) {

        AgentNumResp result = AgentNumResp.builder()
                .backlogNum(0)
                .doneNum(3)
                .build();

        return result;
    }

    public BasePageResp<Object> pageAgentNum(AgentPageReq req) {

        List<Object> data = Lists.newArrayList(
                AgentPageResp.builder()
                        .id(182182)
                        .account("wzzx18")
                        .content("供应商测试-资格审查评审")
                        .createName("")
                        .createTime("2025-10-24T05:49:14.000+0000")
                        .createdTime("")
                        .infoId("c0b939e87b29c7bd22197cd95f6e1e84")
                        .modifyName("")
                        .pushType(3)
                        .redirectUrl("https://req-e.m-bid.cnooc.com.cn/workbench/todoEventIndex?id=c0b939e87b29c7bd22197cd95f6e1e84")
                        .status(true)
                        .title("供应商测试-资格审查评审")
                        .type("资格审查评审")
                        .updatedTime("")
                        .build(),
                AgentPageResp.builder()
                        .id(121804)
                        .account("wzzx18")
                        .content("AutoTest_新签单次合同_货物_生产经营_非集采_法定_邀请招标_20250508134836-资格审查评审")
                        .createName("")
                        .createTime("2025-05-08T06:07:27.000+0000")
                        .createdTime("")
                        .infoId("be027ac3f4a57accb850ae0b2b7fd293")
                        .modifyName("")
                        .pushType(3)
                        .redirectUrl("https://req-e.m-bid.cnooc.com.cn/workbench/todoEventIndex?id=be027ac3f4a57accb850ae0b2b7fd293")
                        .status(true)
                        .title("AutoTest_新签单次合同_货物_生产经营_非集采_法定_邀请招标_20250508134836-资格审查评审")
                        .type("资格审查评审")
                        .updatedTime("")
                        .build(),
                AgentPageResp.builder()
                        .id(120738)
                        .account("wzzx18")
                        .content("物装中心十八已被邀请入库，可进行申请")
                        .createName("")
                        .createTime("2025-04-23T06:54:00.000+0000")
                        .createdTime("")
                        .infoId("e499147e-ebee-4f3b-a3d4-58e897b8f841")
                        .modifyName("")
                        .pushType(3)
                        .redirectUrl("https://req-e.m-bid.cnooc.com.cn/workbench/todoEventIndex?id=c0b939e87b29c7bd22197cd95f6e1e84")
                        .status(true)
                        .title("物装中心十八-专家认证")
                        .type("专家认证")
                        .updatedTime("")
                        .build()
        );

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(3)
                .data(data)
                .build();
    }

    public MessageNumResp getMessageNum(MessageNumReq req) {

        MessageNumResp result = MessageNumResp.builder()
                .read(1)
                .unRead(1)
                .build();

        return result;
    }

    public BasePageResp<Object> pageMessageNum(MessagePageReq req) {

        List<Object> data = Lists.newArrayList(
                MessagePageResp.builder()
                        .id(182182)
                        .contentId("")
                        .createBy("")
                        .createName("")
                        .createTime("2024-12-30 14:53:49")
                        .endTime("")
                        .infoId("c0b939e87b29c7bd22197cd95f6e1e84")
                        .messageContent("专家状态已修改为: 手动冻结")
                        .messageHeader("专家状态已修改为: 手动冻结")
                        .modifyBy("")
                        .modifyName("")
                        .orgId("")
                        .receiver("")
                        .receivers("")
                        .redirectUrl("https://req-e.m-bid.cnooc.com.cn/workbench/todoEventIndex?id=c0b939e87b29c7bd22197cd95f6e1e84")
                        .startTime("")
                        .status(1)
                        .updatedTime("")
                        .visiblePosition("")
                        .build()
        );

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }

}
