package com.cnooc.expert.controller.auth;

import com.cnooc.expert.auth.service.SysCaptchaService;
import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.auth.service.LoginService;
import com.cnooc.expert.system.entity.vo.LoginVO;
import com.cnooc.expert.system.entity.vo.SysCaptchaVO;
import com.cnooc.expert.system.entity.vo.VerifyCodeVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/sys")
public class LoginController {
    @Autowired
    private LoginService loginService;

    @Autowired
    private SysCaptchaService sysCaptchaService;
    /**
     * 手机号验证码/身份证号密码 登录功能
     * @param loginVO 登录表单
     * @return Result<String> 统一返回操作码及信息
     */
    @PostMapping("/login")
    public ApiResult<String> login(@Validated @RequestBody LoginVO loginVO) {
        // 校验loginType 不为空
        return ApiResult.successWithResult(loginService.login(loginVO));
    }
    /**
     * 获取验证码
     * @param vo 手机号等信息
     * @return Result<Integer> 统一返回操作结果及验证码
     */
//    @GetMapping("/sendCode/{phoneNumber}")
    @PostMapping("/sendSmsCode")
    public ApiResult<String> sendCode(@RequestBody LoginVO vo) {
        log.info("获取验证码的手机号: {}", vo.getPhoneNumber());
        return ApiResult.successWithResult(loginService.sendPhoneCode(vo));
    }
    @PostMapping("/verifyCode")
    public ApiResult<String> verifyCode(@RequestBody VerifyCodeVO codeVO) {
        return ApiResult.successWithResult(loginService.verifyCode(codeVO));
    }
    /**
     * 账号修改
     * @param loginVO
     * @return
     */
    @PostMapping("/changePass")
    public ApiResult<String> changePass(@RequestBody LoginVO loginVO) {
        return ApiResult.successWithResult(loginService.changePass(loginVO));
    }

    @GetMapping("/captcha")
    public ApiResult<Map<String, String>> captcha() {
        SysCaptchaVO captchaVO = sysCaptchaService.generate();
        // 5. 构建响应
        Map<String, String> response = new HashMap<>();
        response.put("captchaId", captchaVO.getKey());
        response.put("image", captchaVO.getImage());
        return ApiResult.successWithResult(response);
    }

    /**
     * 验证图片验证码
     */
    @PostMapping("/verifyCaptcha")
    public ResponseEntity<Map<String, Object>> verifyCaptchaNew(
            @RequestParam String captchaId,
            @RequestParam String inputCode) {
        Map<String, Object> result = new HashMap<>();
        boolean flag = sysCaptchaService.validate(captchaId, inputCode);
        String msg = "验证成功";
        if (!flag) {
            msg = "验证失败";
        }
        result.put("success", flag);
        result.put("message", msg);
        return ResponseEntity.ok(result);
    }
}
