package com.cnooc.expert.service;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.expert.model.request.CompanyPageReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaApplyReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuByOwnerPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuInfoGetByChouQuMaReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuPageReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiApplyReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiPageReq;
import com.cnooc.expert.controller.expert.model.response.CompanyPageResp;
import com.cnooc.expert.controller.expert.model.response.DictListItemResp;
import com.cnooc.expert.controller.expert.model.response.ExpertInfoGetResp;
import com.cnooc.expert.controller.expert.model.response.GeRenXiuJiaApplyResp;
import com.cnooc.expert.controller.expert.model.response.GeRenXiuJiaPageResp;
import com.cnooc.expert.controller.expert.model.response.NofilterListItemResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuByOwnerPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuInfoGetByChouQuMaResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoZhuanYeTreeNodeResp;
import com.cnooc.expert.controller.expert.model.response.QingJiaJinJiApplyResp;
import com.cnooc.expert.controller.expert.model.response.QingJiaJinJiPageResp;
import com.cnooc.expert.controller.expert.model.response.SecondaryUnitListItemResp;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetReq;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetTestResp;
import com.cnooc.expert.external.expert.service.ExpertServiceClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@AllArgsConstructor
@Service
public class ExpertService {

    private ObjectMapper objectMapper;

    private final ExpertServiceClient expertServiceClient;

    public String getExpertDetail(int id) throws JsonProcessingException {
        ExpertInfoGetTestResp result = expertServiceClient.getExpertInfo(id);
        return objectMapper.writeValueAsString(result);
    }

    public List<NofilterListItemResp> listDictNofilter(DictNofilterListReq req) {

        ArrayList<NofilterListItemResp> result = Lists.newArrayList(
                NofilterListItemResp.builder()
                        .id("1")
                        .text("汉族")
                        .build(),
                NofilterListItemResp.builder()
                        .id("2")
                        .text("蒙古族")
                        .build()
        );

        return result;
    }

    public List<SecondaryUnitListItemResp> listSecondaryUnit() {

        ArrayList<SecondaryUnitListItemResp> result = Lists.newArrayList(
                SecondaryUnitListItemResp.builder()
                        .code("1")
                        .name("中海油研究总院有限责任公司")
                        .build(),
                SecondaryUnitListItemResp.builder()
                        .code("2")
                        .name("中海石油化工进出口有限公司")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict3() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("zhicheng-fuwu")
                        .key("")
                        .value("服务类")
                        .typeName("职称")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("zhicheng-shebei")
                        .key("")
                        .typeName("职称")
                        .value("设备类")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict4() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("00fbea56-22b8-4f6c-842e-b1953f1bf079")
                        .key("")
                        .typeName("执业资格")
                        .value("一级建造师（通信与广电工程）")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("zhiyezige50")
                        .key("")
                        .typeName("执业资格")
                        .value("其他")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict5() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("625ade01-00f0-4a1f-93d8-66d6b4c5a2b3")
                        .key("")
                        .typeName("学历")
                        .value("博士研究生")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("708932cc-794c-4d1a-b30e-a16afd364495")
                        .key("")
                        .typeName("学历")
                        .value("硕士研究生")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict6() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("28a0942a-84ad-4329-8be4-8196ed3164fe")
                        .key("")
                        .typeName("学位")
                        .value("学士")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("5676942a-84ad-4329-8be4-8196ed3164fe")
                        .key("")
                        .typeName("学位")
                        .value("其他")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict11() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("152cc498-5c44-4fbd-85b9-e6d3653e231b")
                        .key("")
                        .typeName("语种")
                        .value("葡萄牙语")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("ce221ce6-3649-4d0c-bfc9-10acc9d0595e")
                        .key("")
                        .typeName("语种")
                        .value("英语")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict12() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("1798a3ab-dac0-4f71-967d-1f9242327e98")
                        .key("")
                        .typeName("熟练程度")
                        .value("了解")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("529ebc4e-b0ff-4fa2-82fa-abf57e6da61f")
                        .key("")
                        .typeName("熟练程度")
                        .value("熟悉")
                        .build()
        );

        return result;
    }

    public BasePageResp<Object> pageCompany(CompanyPageReq req) {
        List<Object> data = Lists.newArrayList(
                CompanyPageResp.builder()
                        .id("1420053958893662209")
                        .subjectId("1420053958767833088")
                        .subjectName("江苏瑞尔姆电器安安有限公司")
                        .businessType(5)
                        .creditCode("91320577MA4Y6K7H0F")
                        .contactPerson("张三")
                        .contactPhone("13800138000")
                        .contactEmail("zhangsan@cnooc.com.cn")
                        .build(),
                CompanyPageResp.builder()
                        .id("1420051042464067584")
                        .subjectId("1420051042065608705")
                        .subjectName("中海科技很大的公司")
                        .businessType(5)
                        .creditCode("91320507MA4Y6K7H0F")
                        .contactPerson("里斯")
                        .contactPhone("13333333333")
                        .contactEmail("lisi@cnooc.com.cn")
                        .build()
        );

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(2)
                .data(data)
                .build();
    }

    public ExpertInfoGetResp getExpertInfo(ExpertInfoGetReq req) {

        ExpertInfoGetResp.SysShenHeJieGuo sysShenHeJieGuo = ExpertInfoGetResp.SysShenHeJieGuo.builder()
                .bianGengXuHao("")
                .businessId("1364891101101371393")
                .createTime(1745457005237L)
                .createTimeText("2025-04-24 09:10:05")
                .creatorName("物装中心十八")
                .currentNode("")
                .daiShenRenGuids("")
                .daiShenRenNames("")
                .isFinish(true)
                .mobile("15900000018")
                .modifierName("物装中心十八")
                .modifyTime(1747115196797L)
                .modifyTimeText("2025-05-13 13:46:36")
                .nengCheHui(false)
                .photoGuid("")
                .remark("")
                .sequence("")
                .shenFenZheng("15263219990128571X")
                .shenHeRenGuid("")
                .shenPiBuMenGuid("")
                .shenPiBuMenName("")
                .shenPiJiLuGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                .shenPiRen("")
                .shenPiShiJian("")
                .shenPiYiJian("")
                .shenPiZhuangTai(20)
                .shenQingLeiXing(105)
                .shiFouZhuanJiao(false)
                .shiXiangGuid("")
                .shiXiangName("")
                .shiXiangType("")
                .shouLiRen("")
                .shouLiTime(null)
                .shouLiTimeText(null)
                .shouLiZhuanTai(10)
                .tiJiaoRenGuid("")
                .tiJiaoRenName("")
                .tiJiaoTime(null)
                .tiJiaoTimeText("")
                .tuiKuYuanYin("")
                .workFlowBusinessId("1364891101101371393")
                .workFlowBusinessIdNew(null)
                .xiaJiShenHeRenGuid("")
                .xiaJiShenHeRenName("")
                .xiangMuGuid("")
                .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                .zhuanJiaShiXiangGuid("cc9d2be2-07a8-4d59-8c61-5c0854ae2bc2")
                .build();

        List<ExpertInfoGetResp.Zc> zcList = Lists.newArrayList(
                ExpertInfoGetResp.Zc.builder()
                        .base64ZcFile("")
                        .base64ZcFileName("")
                        .createTime(1745393470354L)
                        .createTimeText("2025-04-23 15:31:10")
                        .creatorName("物装中心十八")
                        .dictGuid("")
                        .modifierName("物装中心十八")
                        .modifyTime(1747115258721L)
                        .modifyTimeText("2025-05-20 16:25:58")
                        .pingDingTime(1745393470354L)
                        .pingDingTimeText("2025-04-23 15:31:10")
                        .zcFileGuid("1420053958893662209")
                        .zhiChengGuid("28882bfa-afb4-425b-b50e-945a545fdd82")
                        .zhiChengName("不限")
                        .zhiChengZhuanYe("12")
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                        .ziXinXiGuid("")
                        .build()
        );

        List<ExpertInfoGetResp.XueLi> xueLiList = Lists.newArrayList(
                ExpertInfoGetResp.XueLi.builder()
                        .biYeTime(1745164800000L)
                        .biYeYuanXiao("21")
                        .biYeYuanXiao("")
                        .biYeYuanXiaoGuid("")
                        .byzFileGuid("")
                        .createTime(null)
                        .creatorGuid("1171528722513702912")
                        .creatorName("物装中心十八")
                        .creatorTime(null)
                        .isImport(false)
                        .isZuiGaoXueLi(true)
                        .isZuiGaoXueWei(true)
                        .modifier("")
                        .modifierName("")
                        .modifyTime(1745393482493L)
                        .suoShuZhaoBiaoDaiLi("")
                        .xueLiBh("")
                        .xueLiDictGuid("28a0942a-84ad-4329-8be4-8196ed3164fe")
                        .xueLiGuid("b471705b-205a-4dee-8f62-ad7d7a7c28ed")
                        .xueLiName("博士研究生")
                        .xueLiZhuanYe("12")
                        .xueLiZhuanYeBh("")
                        .xueLiZhuanYeGuid("")
                        .xueWeiBh("")
                        .xueWeiDictGuid("84dab32c-88e2-4ba1-ae74-a45b7bf75b5e")
                        .xueWeiName("博士后")
                        .xwzFileGuid("")
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                        .ziXinXiGuid("")
                        .build()
        );

        List<ExpertInfoGetResp.Ps> psList = Lists.newArrayList(
                ExpertInfoGetResp.Ps.builder()
                        .createTime(1745456982639L)
                        .creatorGuid("-1")
                        .creatorName("系统生成")
                        .modifierGuid("")
                        .modifierName("")
                        .modifyTime(null)
                        .pinQiEndTime(1840064982638L)
                        .pinQiEndTimeText("2028-04-23")
                        .pinQiStartTime(1745424000000L)
                        .pinQiStartTimeText("2025-04-24")
                        .pinShuFuJianGuid("1364891041086844929")
                        .pingShuGuid("7f903e09-e86a-4e8e-a7d0-1b2355fdf0d7")
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaQinRenQi(3)
                        .build()
        );

        List<ExpertInfoGetResp.Jl> jlList = Lists.newArrayList(
                ExpertInfoGetResp.Jl.builder()
                        .buMenName("12")
                        .createTime(1745393470354L)
                        .createTimeText("2025-04-23 15:31:10")
                        .creatorName("物装中心十八")
                        .danWeiBH("")
                        .danWeiName("12")
                        .gongZuoMiaoShu("")
                        .jingLiGuid("b98559d9-35c7-4569-996f-8885923f503d")
                        .liZhiTime(1745337600000L)
                        .liZhiTimeText("2025-04-23 00:00:00")
                        .modifierName("物装中心十八")
                        .modifyTime(1747115258721L)
                        .modifyTimeText("2025-05-13 13:47:38")
                        .riZhiTime(1744646400000L)
                        .riZhiTimeText("2025-04-15 00:00:00")
                        .shenFenZheng("")
                        .tenantId(892422091105296400L)
                        .tenantName("")
                        .zhiWu("12")
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                        .ziXinXiGuid("")
                        .build()
        );

        List<ExpertInfoGetResp.Pb> pbList = Lists.newArrayList(
                ExpertInfoGetResp.Pb.builder()
                        .createTime(1745393470354L)
                        .createTimeText("2025-04-23 15:31:10")
                        .creatorName("物装中心十八")
                        .dongJieEndTime(null)
                        .dongJieFuJianGuid("")
                        .dongJieOperator("")
                        .dongJieReason("")
                        .dongJieSatrtTime(null)
                        .dongJieTime(null)
                        .isPrimary(true)
                        .isScarce(false)
                        .jieDongFuJianGuid("")
                        .jieDongOperator("")
                        .jieDongReason("")
                        .jieDongTime(null)
                        .modifierName("物装中心十八")
                        .modifyTime(1747115258721L)
                        .modifyTimeText("2025-05-13 13:47:38")
                        .parentGuid("0")
                        .path("$$$001$$$")
                        .pingBiaoZhuanYeGuid("22d508e7-7776-4b4a-8c97-f12985cdc251")
                        .professionLevel(1)
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaLeiBie(null)
                        .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                        .zhuanYeBH("001")
                        .zhuanYeGuid("4648caf4-5084-44cd-9120-d18d20950e30")
                        .zhuanYeJiBie("10")
                        .zhuanYeName("拟真环境测试专业勿动")
                        .zhuanYeNianXian(12)
                        .zhuanYeStatus(10)
                        .zhuanYeXiangGuanJingLi("12")
                        .ziXinXiGuid("")
                        .build()
        );

        ExpertInfoGetResp.SysShenHeJieGuo rukuShenHeJieGuo = ExpertInfoGetResp.SysShenHeJieGuo.builder()
                .bianGengXuHao("")
                .businessId("1371846169935306752")
                .createTime(1747115219009L)
                .createTimeText("2025-05-13 13:46:59")
                .creatorName("物装中心十八")
                .currentNode("")
                .daiShenRenGuids("")
                .daiShenRenNames("")
                .isFinish(true)
                .mobile("15900000018")
                .modifierName("物装中心十八")
                .modifyTime(1747115261126L)
                .modifyTimeText("2025-05-13 13:47:41")
                .nengCheHui(false)
                .photoGuid("")
                .remark("")
                .sequence("")
                .shenFenZheng("15263219990128571X")
                .shenHeRenGuid("")
                .shenPiBuMenGuid("")
                .shenPiBuMenName("")
                .shenPiJiLuGuid("60e5723c-6b1c-4022-b34a-ed595d9d6f37")
                .shenPiRen("")
                .shenPiShiJian("")
                .shenPiYiJian("")
                .shenPiZhuangTai(50)
                .shenQingLeiXing(101)
                .shiFouZhuanJiao(false)
                .shiXiangGuid("")
                .shiXiangName("")
                .shiXiangType("")
                .shouLiRen("")
                .shouLiTime(null)
                .shouLiTimeText(null)
                .shouLiZhuanTai(10)
                .tiJiaoRenGuid("1171528722513702912")
                .tiJiaoRenName("物装中心十八")
                .tiJiaoTime(null)
                .tiJiaoTimeText("")
                .tuiKuYuanYin("")
                .workFlowBusinessId("1364891101101371393")
                .workFlowBusinessIdNew("1364617369199915009")
                .xiaJiShenHeRenGuid("")
                .xiaJiShenHeRenName("")
                .xiangMuGuid("")
                .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                .build();

        List<ExpertInfoGetResp.Hb> hbList = Lists.newArrayList(
                ExpertInfoGetResp.Hb.builder()
                        .createTime(1745393470354L)
                        .createTimeText("2025-04-23 15:31:10")
                        .creatorName("物装中心十八")
                        .danWeiBH("")
                        .danWeiName("")
                        .huiBiGuid("03ed2b07-bdf3-4a4d-97b3-bd00050ae634")
                        .huiBiMiaoShu("12")
                        .huiBiMiaoShuStr("")
                        .modifierName("物装中心十八")
                        .modifyTime(1747115258721L)
                        .modifyTimeText("2025-05-13 13:47:38")
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                        .ziXinXiGuid("")
                        .build()
        );

        ExpertInfoGetResp.Bean bean = ExpertInfoGetResp.Bean.builder()
                .adAccount("wzzx18")
                .age(26)
                .authPassWithImport("")
                .auths(null)
                .base64FanMianFuJian("")
                .base64FanMianFuJianName("")
                .base64FuJian("")
                .base64FuJianName("")
                .base64Photo("")
                .base64PhotoName("")
                .baseAuths(null)
                .baseCode("000099")
                .baseGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                .baseMobile("15900000018")
                .baseName("物装中心十八")
                .baseSFZH("15263219990128571X")
                .baseShenPiZhuangTai("30")
                .baseZhuangTai("10")
                .biYeYuanXiao("")
                .bianGengXuHao(0)
                .birthday("1999年01月")
                .buNengRuXuanQingKong("")
                .byzFileGuid("")
                .canYuXiangMu("")
                .city("")
                .createTime(1745391231935L)
                .createTimeText("2025-04-23 14:53:51")
                .creatorName("中国海洋石油集团有限公司")
                .danRenQiTaZhuanJia("")
                .danweiGuid("")
                .department("")
                .domainName("")
                .email("1590000021@cnooc.com.cn")
                .fanMianFuJianGuids("")
                .fax("")
                .fuJianGuids("")
                .gongZuoBeiZhu("")
                .gongZuoDanWei("中化建国际招标有限责任公司天津分公司")
                .gongZuoDanWeiBH("")
                .gongZuoDanWeiDiZhi("12")
                .gongZuoPhone("")
                .gongZuoPost("")
                .gongZuoTime(null)
                .gongZuoZhiWu("12")
                .gongZuoZhuanYeName("")
                .gongZuoZhuanYeYears("")
                .gongZuoZhuangTai(1)
                .graduationDate("")
                .hasLianJieChuLiYiJian(false)
                .huoJiangQingKuang("")
                .inGroup(false)
                .isHasLianJieChuLiYiJian(false)
                .isQualified(true)
                .isReadRuKuPromise(true)
                .isSenior(false)
                .isZhiYeZiGe(false)
                .jgdmFileGuid("")
                .jiTuanErJiDanWeiCode("")
                .jiTuanErJiDanWeiName("中国海洋石油集团有限公司")
                .jiaTingDiZhi("")
                .jiaTingPhone("15900000011")
                .jiaTingPost("")
                .jianKangZhuangKuang("")
                .jinJiLianXiRenGuid("")
                .jinJiLianXiRenName("")
                .jinJiLianXiRenPhone("")
                .kaoShiFenShu(null)
                .leiJiFenZhi(0)
                .leiJiZhanTingTime(null)
                .lianJieYiJianShuFuJianGuid("")
                .lsFuJian(null)
                .minZu("")
                .minZuText("")
                .mobile("15900000018")
                .mobileGJQHText("15900000018")
                .mobileGuoJiQuHao("")
                .modifierName("杨斌")
                .modifyTime(1755689152526L)
                .modifyTimeText("2025-08-20 19:25:52")
                .needTest(false)
                .photoGuid("")
                .pingBiaoChangZhuDiQu("110101")
                .pingBiaoChangZhuDiQuName("")
                .pingBiaoIsYingJi(false)
                .pingBiaoQiTaDiQu("")
                .pingBiaoTuiJianLX(null)
                .pingBiaoYingJiDiQu("")
                .pinqiEndTime(1840064982638L)
                .pinqiStartTime(1745424000000L)
                .professionLevel("")
                .qiTaLianXiFangShi("")
                .qualified(true)
                .readRuKuPromise(true)
                .readRuKuPromiseTime(1745391797759L)
                .ruKuZhuangTai(900)
                .senior(false)
                .sex(true)
                .sfzFileGuid("")
                .sfzFuJians(null)
                .shenFenZheng("15263219990128571X")
                .shenHeEndTime(null)
                .shenHeStartTime(null)
                .shenPiRen("")
                .shenPiShiJian(null)
                .shenPiShiJianText("")
                .shenPiYiJian("")
                .shenPiZhuangTai(30)
                .shenQingEndTime(null)
                .shenQingLeiXing(101)
                .shenQingStartTime(null)
                .shiFouYiFaZhuanJia(false)
                .subjectCode("91120116MA829PHX9X")
                .subjectId("1355213128952123392")
                .subjectName("中化建国际招标有限责任公司天津分公司")
                .subjectType(1)
                .suoShuBuMeng("12")
                .suoShuDanWeiName("中国海洋石油集团有限公司")
                .suoShuHangYe("")
                .suoShuZhaoBiaoDaiLi("91110000710932216U")
                .suoZaiQitaZhuanJiaKu("")
                .tenantId("892422091105296400")
                .tenantId_("")
                .tenantName("")
                .tiJiaoTime(null)
                .tiJiaoTimeText("")
                .tuiKuYuanYin("")
                .waiYuChengDu("")
                .xueLi("")
                .xueLiTxt("")
                .xueLiZhuanYe("")
                .xueWei("")
                .xueWeiTxt("")
                .xueWeiZhuanYe("")
                .yinHang("12121")
                .yinHang1("")
                .yinHangKa("123131311212")
                .yinHangKaFileGuid("")
                .yingJiZhuangTai(null)
                .zhangHao("")
                .zhaoBiaoDanWeiBianHao("")
                .zhaoBiaoDanweiMingChen("")
                .zhengJianType("0")
                .zhengZhiMianMao("")
                .zhiYeZiGe(false)
                .zhuanJiaCode("000099")
                .zhuanJiaFenJi(30)
                .zhuanJiaFenLei(2)
                .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                .zhuanJiaName("物装中心十八")
                .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                .zhuanJiaSourceType(1)
                .zhuanJiaSuoZaiDiGuids("110000110100110101")
                .zhuanJiaSuoZaiDiNames("北京市北京市东城区")
                .zhuanJiaType(null)
                .zhuanJiaZhuangTai(10)
                .zhuanJiaZiZhiTiaoJian("")
                .zhuanJiaZongHeBianHao("PT000099")
                .zhuanYeJingLi("")
                .zhuanYeTeChang("")
                .zhuanjiaQinRenQi(3)
                .ziDongZanTingEndTime(null)
                .ziDongZanTingStartTime(null)
                .build();

        List<ExpertInfoGetResp.FuJian> fuJianList = Lists.newArrayList(
                ExpertInfoGetResp.FuJian.builder()
                        .createTime(1745393470744L)
                        .creatorGuid("1171528722513702912")
                        .creatorName("物装中心十八")
                        .downloadUrl("https://purb.m-bid.cnooc.com.cn/bid-mimic-cggl/892422091105296385/2/2025/4/23/1364617976113278976/%E4%BF%9D%E8%AF%81%E9%87%91%E3%80%81%E6%9C%8D%E5%8A%A1%E8%B4%B91.0.7.20250415.pdf?response-content-disposition=attachment%3Bfilename%3D%25E4%25BF%259D%25E8%25AF%2581%25E9%2587%2591%25E3%2580%2581%25E6%259C%258D%25E5%258A%25A1%25E8%25B4%25B91.0.7.20250415.pdf&AWSAccessKeyId=5T0WWU7JAUDUXJ2EG1FB&Expires=1745393679&Signature=N26QXpJBR7EFBi95KCnj6A1gg2w%3D")
                        .feiQiRenGuid("")
                        .feiQiRenName("")
                        .feiQiTime(null)
                        .fileDescription("")
                        .fileName("保证金、服务费1.0.7.20250415.pdf")
                        .fileSize(650921)
                        .fileType(4)
                        .fuJianGuid("1364617976113278976")
                        .isFeiQi(false)
                        .modifierGuid("")
                        .modifierName("")
                        .modifyTime(1745393482507L)
                        .shenHeRenGuid("")
                        .shenHeRenName("")
                        .shenHeStatus(30)
                        .shenHeTime(null)
                        .shenHeYiJian("")
                        .tiJiaoTime(1745391879721L)
                        .zhuanJiaFuJianGuid("1e2b5d5d-7b3c-4f26-87f0-2c1f45daa982")
                        .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                        .zhuanJiaShiXiangGuid("1402705b-0424-4f39-913c-7793b7b9f5d1")
                        .ziXinXiGuid("")
                        .build()
        );

        ExpertInfoGetResp result = ExpertInfoGetResp.builder()
                .businessId("1364891101101371393")
                .bean(bean)
                .zcList(zcList)
                .sysShenHeJieGuo(sysShenHeJieGuo)
                .xueLiList(xueLiList)
                .zgList(Collections.emptyList())
                .psList(psList)
                .jlList(jlList)
                .pbList(pbList)
                .rukuShenHeJieGuo(rukuShenHeJieGuo)
                .hbList(hbList)
                .pinQiStartTime("2028-04-23")
                .pinQiEndTime("2028-04-23")
                .languageList(Collections.emptyList())
                .fuJianList(fuJianList)
                .build();

        return result;
    }

    public PingBiaoXiangMuInfoGetByChouQuMaResp getPingBiaoXiangMuInfoByChouQuMa(PingBiaoXiangMuInfoGetByChouQuMaReq req) {

        PingBiaoXiangMuInfoGetByChouQuMaResp result = PingBiaoXiangMuInfoGetByChouQuMaResp.builder()
                .chouQuQingKuangGuid("5e2f90be-b8ad-4a8e-931d-cdaae5f1c118")
                .xiangMuNo("XCGSQ2025091236")
                .xiangMuName("0923采购申请资格审查")
                .qingJiaTime(null)
                .chouQuRenWuGuid("6923480b-22ab-4b0d-b7d3-95450d7fed82")
                .pingBiaoStartTime(1758609816544L)
                .zhuanJiaName("物装中心十七")
                .shenHeStatus(null)
                .pingBiaoAddress("北京市京信大厦28层")
                .status(10)
                .build();

        return result;
    }

    public BasePageResp<Object> pageJinJiQingJia(QingJiaJinJiPageReq req) {
        List<Object> data = Lists.newArrayList(
                QingJiaJinJiPageResp.builder()
                        .chouQuNum("202509236391")
                        .jinJiQingJiaGuid("800abddb-e866-439b-93e6-2ac3f9dee3c8")
                        .chouQuQingKuangGuid("5e2f90be-b8ad-4a8e-931d-cdaae5f1c118")
                        .chouQuZhuangTai(null)
                        .xiangMuNo("XCGSQ2025091236")
                        .xiangMuName("0923采购申请资格审查")
                        .jinJiQingJiaReason("1111")
                        .qingJiaTime(1763037471982L)
                        .isQingJia(false)
                        .pingBiaoStartTime(1758609816544L)
                        .shenHeStatus(50)
                        .pingBiaoEndTime(1758624216544L)
                        .build()

        );

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }

    public BasePageResp<Object> pagePingBiaoXiangMu(PingBiaoXiangMuPageReq req) {

        PingBiaoXiangMuPageResp.ZjcqChouQuQingKuang cqqk = PingBiaoXiangMuPageResp.ZjcqChouQuQingKuang.builder()
                .adAccount("")
                .bankCard("")
                .bankName("")
                .bidSectionId(null)
                .buChouReason("")
                .chongXinTongZhiStatus(null)
                .chouQuCiShu(1)
                .chouQuNum("202509236135")
                .chouQuQingKuangGuid("c14061e0-6a79-40d8-9317-e080bbf4a8f3")
                .chouQuRenWuGuid("6923480b-22ab-4b0d-b7d3-95450d7fed82")
                .chouQuType(10)
                .chouQuZhuanYeGuid("a51a0e98-396a-46a6-881e-889609dd00cb")
                .createTime(1758610110239L)
                .createTimeText("2025-09-23 14:48:30")
                .creatorGuid("1371780505761468417")
                .creatorName("")
                .danWeiBH("")
                .danWeiName("中化建国际招标有限责任公司天津分公司")
                .diQu("")
                .email("1590000021@cnooc.com.cn")
                .erJiKuName("")
                .haveChengFa(false)
                .isBuChou(false)
                .isCancel(false)
                .isDuanXinQueRen(true)
                .isFeiQi(false)
                .isFeiQiText("否")
                .isHuLue(false)
                .isNewChouQu(false)
                .isSuoDing(false)
                .isTuiSongSJTJ(false)
                .isXiuGaiRenGongTongZhi(false)
                .jianKuangBaoFuJianGuid("")
                .jinJiQingJiaGuid("")
                .jinJiQingJiaTime(null)
                .meetingId("")
                .meetingPassWord("")
                .mobile("15900000018")
                .modifierName("合同四")
                .modifyTime(1758610477749L)
                .modifyTimeText("2025-09-23 14:54:37")
                .pingBiaoAddress("北京市京信大厦28层")
                .pingBiaoDiQuGuid("110100")
                .pingBiaoEndTime(1758624216544L)
                .pingBiaoEndTimeText("2025-09-23 18:43:36")
                .pingBiaoFenZhongXin("")
                .pingBiaoStartTime(1758609816544L)
                .pingBiaoStartTimeText("2025-09-23 14:43:36")
                .pingShenDiDian("110000,110100,110105")
                .professionLevel(null)
                .qianDaoTime(null)
                .qingJiaCreatorName("")
                .qingJiaSource(null)
                .qingJiaTime(null)
                .qingJiaTimeNode(null)
                .reason("")
                .sealValidTime(null)
                .sendHealthStatus(false)
                .shenFenZheng("BB94A0293969808540687D32F2AE3C9A082005536A0A49AF72822987955D8D16")
                .shenHeStatus(null)
                .status(2)
                .tag("")
                .tenantId(892422091105296385L)
                .tenantName("")
                .tongZhiCiShu(1)
                .tongZhiFangShi(20)
                .tongZhiJieGuo(2)
                .tuiSongShiBaiCiShuSJTJ(null)
                .xiangMuGuid("a4168ddc-f8b2-4244-bc9b-b4ec6d7f8266")
                .xiangMuName("")
                .xiangMuNo("")
                .xingChengMaFuJianGuid("")
                .zhiChengName("")
                .zhiDingZhuanJiaType(null)
                .zhuanJiaCode("000099")
                .zhuanJiaDengJi(null)
                .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                .zhuanJiaName("物装中心十八")
                .zhuanJiaShuXing("")
                .zhuanJiaSuoZaiDiCode("")
                .zhuanJiaSuoZaiDiGuids("")
                .zhuanJiaSuoZaiDiName("")
                .zhuanYeCode("A00001")
                .zhuanYeGuid("62848bc2-6b2d-4549-9e33-13121cf0c3ae")
                .zhuanYeGuidPri("62848bc2-6b2d-4549-9e33-13121cf0c3ae")
                .zhuanYeName("测试A00001")
                .build();

        PingBiaoXiangMuPageResp.DictPingBiaoZhuanYe dictPingBiaoZhuanYe = PingBiaoXiangMuPageResp.DictPingBiaoZhuanYe.builder()
                .checked(false)
                .createTime(1660731959615L)
                .createTimeText("2022-08-17 18:25:59")
                .creatorName("dev-test")
                .excelForLevel(null)
                .excelForNumber("")
                .excelForNumberParent("")
                .excelIsChecked(null)
                .hasLastChildZY(false)
                .isHide(false)
                .isScarce(false)
                .lastLevel(false)
                .level(null)
                .lsChildren(null)
                .miaoShu("")
                .modifierName("郑炯达")
                .modifyTime(1675057207760L)
                .modifyTimeText("2023-01-30 13:40:07")
                .oldScarce(false)
                .paiXuHao(1)
                .parentGuid("0")
                .path("$$$A00001$$$")
                .professionLevel(1)
                .scarce(false)
                .state("")
                .suoShuZhaoBiaoDaiLi("91110000710932216U")
                .xiaquCode(123456789)
                .yingJiKuKeChouNum(null)
                .yingJiKuNum(null)
                .zhengChangKuKeChouNum(null)
                .zhengChangKuNum(2)
                .zhuKuNum(null)
                .zhuanJiaLeiBie(null)
                .zhuanYeBH("A00001")
                .zhuanYeGuid("62848bc2-6b2d-4549-9e33-13121cf0c3ae")
                .zhuanYeName("测试A00001")
                .zhuanYeShuXing(2)
                .build();

        PingBiaoXiangMuPageResp item = PingBiaoXiangMuPageResp.builder()
                .chouQuFangShi(10)
                .chouQuRenDanWei("")
                .chouQuRenName("")
                .chouQuRenPhone("")
                .chouQuZhuanTai(null)
                .createTime(1758609082178L)
                .createTimeText("2025-09-23 14:31:22")
                .creatorGuid("")
                .creatorName("")
                .fanKuiYiJian("")
                .isCQDHuanZhuanYe(false)
                .isSubmit(null)
                .jianDuRenDanWei("")
                .jianDuRenName("")
                .jingBanRen("")
                .jingBanRenPhone("")
                .keywords("123")
                .messageContent("")
                .modifierGuid("")
                .modifierName("")
                .modifyTime(1758610073858L)
                .modifyTimeText("2025-09-23 14:47:53")
                .pingJiaStatus(1)
                .pingShenType(30)
                .projectId("")
                .reevaluation(false)
                .reevaluationName("")
                .shuJuLaiYuan(0)
                .submitTime(null)
                .submitTimeText("")
                .tenantId(892422091105296385L)
                .tenantName("")
                .tiJiaoEndTime(null)
                .tiJiaoEndTimeText("")
                .tiJiaoStartTime(null)
                .tiJiaoStartTimeText("")
                .tongZhiFangShi(null)
                .workFlowBusinessIdNew("")
                .xiangMuApplyName("")
                .xiangMuApplyNo("c5472c04-9754-44f0-bd93-9c0e70cd6ef7")
                .xiangMuAttr(null)
                .xiangMuCaiGouDanWei("")
                .xiangMuDaiMa("")
                .xiangMuGuid("a4168ddc-f8b2-4244-bc9b-b4ec6d7f8266")
                .xiangMuLaiYuan(null)
                .xiangMuName("0923采购申请资格审查")
                .xiangMuNo("XCGSQ2025091236")
                .xiangMuType(0)
                .xiangMuWho(1)
                .zhaoBiaoFangShi("")
                .zjcqXiangMuStatus(null)
                .cqqk(cqqk)
                .dictPingBiaoZhuanYe(dictPingBiaoZhuanYe)
                .build();

        List<Object> data = Lists.newArrayList(item);

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }

    public List<PingBiaoZhuanYeTreeNodeResp> treePingBiaoZhuanYe() {

        List<PingBiaoZhuanYeTreeNodeResp> children3 = Lists.newArrayList(
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .id("c59fd63413a55127ee575af9acebf7f8")
                        .code("A020102")
                        .name("铁路")
                        .level(null)
                        .sort(null)
                        .path("$$$A02$$$A0201$$$A020102$$$")
                        .children(Collections.emptyList())
                        .build(),
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .id("3e045f75167b06eaaa9332dddca76504")
                        .code("A020107")
                        .name("火电")
                        .level(null)
                        .sort(null)
                        .path("$$$A02$$$A0201$$$A020102$$$")
                        .children(Collections.emptyList())
                        .build()
        );
        List<PingBiaoZhuanYeTreeNodeResp> children2 = Lists.newArrayList(
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .id("ee219c9d3163151add3474ba296f55da")
                        .code("A0201")
                        .name("投资策划与决策")
                        .level(null)
                        .sort(null)
                        .path("$$$A02$$$A0201$$$")
                        .children(children3)
                        .build()
        );

        List<PingBiaoZhuanYeTreeNodeResp> children1 = Lists.newArrayList(
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .id("2fbccc3477502e9fae23a1f50dee27e2")
                        .code("A02")
                        .name("投资策划与决策")
                        .level(null)
                        .sort(null)
                        .path("$$$A02$$$")
                        .children(children2)
                        .build()
        );


        return children1;
    }

    public QingJiaJinJiApplyResp applyJinJiQingJia(QingJiaJinJiApplyReq req) {

        return QingJiaJinJiApplyResp.builder()
                .chouQuQingKuangGuid("5e2f90be-b8ad-4a8e-931d-cdaae5f1c118")
                .chouQuRenWuGuid("6923480b-22ab-4b0d-b7d3-95450d7fed82")
                .createTime(1763037473819L)
                .createTimeText("2025-11-13 20:37:53")
                .creatorGuid("1171528721049890817")
                .creatorName("物装中心二")
                .jinJiQingJiaGuid("800abddb-e866-439b-93e6-2ac3f9dee3c8")
                .jinJiQingJiaReason("1111")
                .qingJiaSource("")
                .qingJiaTime(1763037471982L)
                .qingJiaTimeNode(null)
                .qingJiaTimeText("2025-11-13 20:37:51")
                .shenHeStatus(50)
                .build();
    }

    public BasePageResp<Object> pageGeRenXiuJia(GeRenXiuJiaPageReq req) {
        List<Object> data = Lists.newArrayList(
                GeRenXiuJiaPageResp.builder()
                        .createTime(1761198859239L)
                        .createTimeText("2025-10-23 13:54:19")
                        .creatorName("物装中心十七")
                        .endTime(1761408000000L)
                        .endTimeText("2025-10-26 00:00:00")
                        .isHaveChanged(false)
                        .isXiTongQj(false)
                        .leiXing(1)
                        .modifierName("物装中心十七")
                        .modifyTime(1761198867075L)
                        .modifyTimeText("2025-10-23 13:54:27")
                        .qingJiaDays("1.0")
                        .qingJiaEndTime(null)
                        .qingJiaGuid("05317e7a-5e19-4125-a088-1d5256aa5eed")
                        .qingJiaStartTime(null)
                        .qingJiaYuanYin("ceshiyixia")
                        .remark("")
                        .shenFenZheng("")
                        .shenPiTime(null)
                        .shenPiTimeText("")
                        .shenPiYiJian("")
                        .shenPiZhuangTai(null)
                        .startTime(1761321600000L)
                        .startTimeText("2025-10-25 00:00:00")
                        .tiJiaoTime(null)
                        .tiJiaoTimeText("")
                        .xiaoJiaTime(1761198867075L)
                        .xiaoJiaTimeText("2025-10-23 13:54:27")
                        .zhuanJiaCode("")
                        .zhuanJiaGuid("3b5def9d-2e98-4f90-9aaa-10aefd28c61b")
                        .zhuanJiaName("")
                        .build()

        );

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }

    public GeRenXiuJiaApplyResp applyGeRenXiuJia(GeRenXiuJiaApplyReq req) {

        return GeRenXiuJiaApplyResp.builder()
                .createTime(1763038871315L)
                .createTimeText("2025-11-13 21:01:11")
                .creatorName("物装中心十七")
                .endTime(1762531200000L)
                .endTimeText("2025-11-08 00:00:00")
                .isHaveChanged(false)
                .isXiTongQj(false)
                .leiXing(1)
                .modifierName("")
                .modifyTime(null)
                .modifyTimeText("")
                .qingJiaDays(2)
                .qingJiaEndTime(null)
                .qingJiaGuid("81d87a6c-6619-409d-abcb-4638d4853fe0")
                .qingJiaStartTime(null)
                .qingJiaYuanYin("111")
                .remark("")
                .shenFenZheng("")
                .shenPiTime(null)
                .shenPiTimeText("")
                .shenPiYiJian("")
                .shenPiZhuangTai(null)
                .startTime(1762358400000L)
                .startTimeText("2025-11-06 00:00:00")
                .tiJiaoTime(null)
                .tiJiaoTimeText("")
                .xiaoJiaTime(null)
                .xiaoJiaTimeText("")
                .zhuanJiaCode("")
                .zhuanJiaGuid("3b5def9d-2e98-4f90-9aaa-10aefd28c61b")
                .zhuanJiaName("")
                .build();
    }

    public BasePageResp<Object> pagePingBiaoXiangmuByOwner(PingBiaoXiangMuByOwnerPageReq req) {

        PingBiaoXiangMuByOwnerPageResp.ZjcqChouQuQingKuang cqqk = PingBiaoXiangMuByOwnerPageResp.ZjcqChouQuQingKuang.builder()
                .adAccount("")
                .bankCard("")
                .bankName("")
                .bidSectionId(null)
                .buChouReason("")
                .chongXinTongZhiStatus(null)
                .chouQuCiShu(1)
                .chouQuNum("202509236135")
                .chouQuQingKuangGuid("c14061e0-6a79-40d8-9317-e080bbf4a8f3")
                .chouQuRenWuGuid("6923480b-22ab-4b0d-b7d3-95450d7fed82")
                .chouQuType(10)
                .chouQuZhuanYeGuid("a51a0e98-396a-46a6-881e-889609dd00cb")
                .createTime(1758610110239L)
                .createTimeText("2025-09-23 14:48:30")
                .creatorGuid("1371780505761468417")
                .creatorName("")
                .danWeiBH("")
                .danWeiName("中化建国际招标有限责任公司天津分公司")
                .diQu("")
                .email("1590000021@cnooc.com.cn")
                .erJiKuName("")
                .haveChengFa(false)
                .isBuChou(false)
                .isCancel(false)
                .isDuanXinQueRen(true)
                .isFeiQi(false)
                .isFeiQiText("否")
                .isHuLue(false)
                .isNewChouQu(false)
                .isSuoDing(false)
                .isTuiSongSJTJ(false)
                .isXiuGaiRenGongTongZhi(false)
                .jianKuangBaoFuJianGuid("")
                .jinJiQingJiaGuid("")
                .jinJiQingJiaTime(null)
                .meetingId("")
                .meetingPassWord("")
                .mobile("15900000018")
                .modifierName("合同四")
                .modifyTime(1758610477749L)
                .modifyTimeText("2025-09-23 14:54:37")
                .pingBiaoAddress("北京市京信大厦28层")
                .pingBiaoDiQuGuid("110100")
                .pingBiaoEndTime(1758624216544L)
                .pingBiaoEndTimeText("2025-09-23 18:43:36")
                .pingBiaoFenZhongXin("")
                .pingBiaoStartTime(1758609816544L)
                .pingBiaoStartTimeText("2025-09-23 14:43:36")
                .pingShenDiDian("110000,110100,110105")
                .professionLevel(null)
                .qianDaoTime(null)
                .qingJiaCreatorName("")
                .qingJiaSource(null)
                .qingJiaTime(null)
                .qingJiaTimeNode(null)
                .reason("")
                .sealValidTime(null)
                .sendHealthStatus(false)
                .shenFenZheng("BB94A0293969808540687D32F2AE3C9A082005536A0A49AF72822987955D8D16")
                .shenHeStatus(null)
                .status(2)
                .tag("")
                .tenantId(892422091105296385L)
                .tenantName("")
                .tongZhiCiShu(1)
                .tongZhiFangShi(20)
                .tongZhiJieGuo(2)
                .tuiSongShiBaiCiShuSJTJ(null)
                .xiangMuGuid("a4168ddc-f8b2-4244-bc9b-b4ec6d7f8266")
                .xiangMuName("")
                .xiangMuNo("")
                .xingChengMaFuJianGuid("")
                .zhiChengName("")
                .zhiDingZhuanJiaType(null)
                .zhuanJiaCode("000099")
                .zhuanJiaDengJi(null)
                .zhuanJiaGuid("1b4ffa58-2197-4b91-8178-3f49bd100f09")
                .zhuanJiaName("物装中心十八")
                .zhuanJiaShuXing("")
                .zhuanJiaSuoZaiDiCode("")
                .zhuanJiaSuoZaiDiGuids("")
                .zhuanJiaSuoZaiDiName("")
                .zhuanYeCode("A00001")
                .zhuanYeGuid("62848bc2-6b2d-4549-9e33-13121cf0c3ae")
                .zhuanYeGuidPri("62848bc2-6b2d-4549-9e33-13121cf0c3ae")
                .zhuanYeName("测试A00001")
                .build();

        PingBiaoXiangMuByOwnerPageResp.DictPingBiaoZhuanYe dictPingBiaoZhuanYe = PingBiaoXiangMuByOwnerPageResp.DictPingBiaoZhuanYe.builder()
                .checked(false)
                .createTime(1660731959615L)
                .createTimeText("2022-08-17 18:25:59")
                .creatorName("dev-test")
                .excelForLevel(null)
                .excelForNumber("")
                .excelForNumberParent("")
                .excelIsChecked(null)
                .hasLastChildZY(false)
                .isHide(false)
                .isScarce(false)
                .lastLevel(false)
                .level(null)
                .lsChildren(null)
                .miaoShu("")
                .modifierName("郑炯达")
                .modifyTime(1675057207760L)
                .modifyTimeText("2023-01-30 13:40:07")
                .oldScarce(false)
                .paiXuHao(1)
                .parentGuid("0")
                .path("$$$A00001$$$")
                .professionLevel(1)
                .scarce(false)
                .state("")
                .suoShuZhaoBiaoDaiLi("91110000710932216U")
                .xiaquCode(123456789)
                .yingJiKuKeChouNum(null)
                .yingJiKuNum(null)
                .zhengChangKuKeChouNum(null)
                .zhengChangKuNum(2)
                .zhuKuNum(null)
                .zhuanJiaLeiBie(null)
                .zhuanYeBH("A00001")
                .zhuanYeGuid("62848bc2-6b2d-4549-9e33-13121cf0c3ae")
                .zhuanYeName("测试A00001")
                .zhuanYeShuXing(2)
                .build();

        PingBiaoXiangMuByOwnerPageResp item = PingBiaoXiangMuByOwnerPageResp.builder()
                .chouQuFangShi(10)
                .chouQuRenDanWei("")
                .chouQuRenName("")
                .chouQuRenPhone("")
                .chouQuZhuanTai(null)
                .createTime(1758609082178L)
                .createTimeText("2025-09-23 14:31:22")
                .creatorGuid("")
                .creatorName("")
                .fanKuiYiJian("")
                .isCQDHuanZhuanYe(false)
                .isSubmit(null)
                .jianDuRenDanWei("")
                .jianDuRenName("")
                .jingBanRen("")
                .jingBanRenPhone("")
                .keywords("123")
                .messageContent("")
                .modifierGuid("")
                .modifierName("")
                .modifyTime(1758610073858L)
                .modifyTimeText("2025-09-23 14:47:53")
                .pingJiaStatus(1)
                .pingShenType(30)
                .projectId("")
                .reevaluation(false)
                .reevaluationName("")
                .shuJuLaiYuan(0)
                .submitTime(null)
                .submitTimeText("")
                .tenantId(892422091105296385L)
                .tenantName("")
                .tiJiaoEndTime(null)
                .tiJiaoEndTimeText("")
                .tiJiaoStartTime(null)
                .tiJiaoStartTimeText("")
                .tongZhiFangShi(null)
                .workFlowBusinessIdNew("")
                .xiangMuApplyName("")
                .xiangMuApplyNo("c5472c04-9754-44f0-bd93-9c0e70cd6ef7")
                .xiangMuAttr(null)
                .xiangMuCaiGouDanWei("")
                .xiangMuDaiMa("")
                .xiangMuGuid("a4168ddc-f8b2-4244-bc9b-b4ec6d7f8266")
                .xiangMuLaiYuan(null)
                .xiangMuName("0923采购申请资格审查")
                .xiangMuNo("XCGSQ2025091236")
                .xiangMuType(0)
                .xiangMuWho(1)
                .zhaoBiaoFangShi("")
                .zjcqXiangMuStatus(null)
                .cqqk(cqqk)
                .dictPingBiaoZhuanYe(dictPingBiaoZhuanYe)
                .build();

        List<Object> data = Lists.newArrayList(item);

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }
}
