package com.cnooc.expert.service;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.expert.model.request.CompanyPageReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.response.CompanyPageResp;
import com.cnooc.expert.controller.expert.model.response.DictListItemResp;
import com.cnooc.expert.controller.expert.model.response.NofilterListItemResp;
import com.cnooc.expert.controller.expert.model.response.SecondaryUnitListItemResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetResp;
import com.cnooc.expert.external.expert.service.ExpertServiceClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@Service
public class ExpertService {

    private ObjectMapper objectMapper;

    private final ExpertServiceClient expertServiceClient;

    public String getExpertDetail(int id) throws JsonProcessingException {
        ExpertInfoGetResp result = expertServiceClient.getExpertInfo(id);
        return objectMapper.writeValueAsString(result);
    }

    public List<NofilterListItemResp> listDictNofilter(DictNofilterListReq req) {

        ArrayList<NofilterListItemResp> result = Lists.newArrayList(
                NofilterListItemResp.builder()
                        .id("1")
                        .text("汉族")
                        .build(),
                NofilterListItemResp.builder()
                        .id("2")
                        .text("蒙古族")
                        .build()
        );

        return result;
    }

    public List<SecondaryUnitListItemResp> listSecondaryUnit() {

        ArrayList<SecondaryUnitListItemResp> result = Lists.newArrayList(
                SecondaryUnitListItemResp.builder()
                        .code("1")
                        .name("中海油研究总院有限责任公司")
                        .build(),
                SecondaryUnitListItemResp.builder()
                        .code("2")
                        .name("中海石油化工进出口有限公司")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict4() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .key("1")
                        .value("一级建造师（通信与广电工程）")
                        .build(),
                DictListItemResp.builder()
                        .key("2")
                        .value("二级建造师（通信与广电工程）")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict5() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("625ade01-00f0-4a1f-93d8-66d6b4c5a2b3")
                        .key("")
                        .value("博士研究生")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("708932cc-794c-4d1a-b30e-a16afd364495")
                        .key("")
                        .value("硕士研究生")
                        .build()
        );

        return result;
    }

    public List<DictListItemResp> listDict6() {

        ArrayList<DictListItemResp> result = Lists.newArrayList(
                DictListItemResp.builder()
                        .dictGuid("28a0942a-84ad-4329-8be4-8196ed3164fe")
                        .key("")
                        .value("学士")
                        .build(),
                DictListItemResp.builder()
                        .dictGuid("5676942a-84ad-4329-8be4-8196ed3164fe")
                        .key("")
                        .value("其他")
                        .build()
        );

        return result;
    }

    public BasePageResp<Object> pageCompany(CompanyPageReq req) {
        List<Object> data = Lists.newArrayList(
                CompanyPageResp.builder()
                        .id("1420053958893662209")
                        .subjectId("1420053958767833088")
                        .subjectName("江苏瑞尔姆电器安安有限公司")
                        .businessType(5)
                        .creditCode("91320577MA4Y6K7H0F")
                        .contactPerson("张三")
                        .contactPhone("13800138000")
                        .contactEmail("zhangsan@cnooc.com.cn")
                        .build(),
                CompanyPageResp.builder()
                        .id("1420051042464067584")
                        .subjectId("1420051042065608705")
                        .subjectName("中海科技很大的公司")
                        .businessType(5)
                        .creditCode("91320507MA4Y6K7H0F")
                        .contactPerson("里斯")
                        .contactPhone("13333333333")
                        .contactEmail("lisi@cnooc.com.cn")
                        .build()
        );

        return BasePageResp.builder()
                .current(1)
                .pages(1)
                .total(2)
                .data(data)
                .build();
    }

    public Object getExpertInfo(CompanyPageReq req) {


        return null;
    }
}
