package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.expert.model.request.*;
import com.cnooc.expert.controller.expert.model.response.*;
import com.cnooc.expert.service.ExpertService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/expert")
public class ExpertController {

    private final ExpertService expertService;

    @GetMapping("/get")
    public String expertGet() throws JsonProcessingException {
        return expertService.getExpertDetail(1);
    }

    // *** 数据字典 ***

    /**
     * 民族查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/nofilter/list")
    public ApiResult<List<NofilterListItemResp>> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        return ApiResult.successWithResult(expertService.listDictNofilter(req));
    }

    /**
     * 集团二级单位列表
     *
     * @return
     */
    @PostMapping("/secondary-unit/list")
    public ApiResult<List<SecondaryUnitListItemResp>> secondaryUnitList() {
        return ApiResult.successWithResult(expertService.listSecondaryUnit());
    }

    /**
     * 职称列表
     *
     * @return
     */
    @PostMapping("/dict/guid4/list")
    public ApiResult<List<DictListItemResp>> dictGuiud4List() {
        return ApiResult.successWithResult(expertService.listDict4());
    }

    /**
     * 学历列表
     *
     * @return
     */
    @PostMapping("/dict/guid5/list")
    public ApiResult<List<DictListItemResp>> dictGuiud5List() {
        return ApiResult.successWithResult(expertService.listDict5());
    }


    /**
     * 学位列表
     *
     * @return
     */
    @PostMapping("/dict/guid6/list")
    public ApiResult<List<DictListItemResp>> dictGuiud6List() {
        return ApiResult.successWithResult(expertService.listDict6());
    }

    /**
     * 公司列表
     *
     * @return
     */
    @PostMapping("/company/page")
    public ApiResult<BasePageResp<Object>> companyPage(@RequestBody @Validated CompanyPageReq req) {
        return ApiResult.successWithResult(expertService.pageCompany(req));
    }

    /**
     * 专家个人信息
     *
     * @return
     */
    @PostMapping("/info")
    public ApiResult<ExpertInfoGetResp> ExpertInfoGet() {
        return ApiResult.successWithResult(expertService.getExpertInfo(null));
    }

    /**
     * 抽取码详情
     *
     * @param req
     * @return
     */
    @PostMapping("/pingBiaoXiangMu/info-by-chouqunum")
    public ApiResult<PingBiaoXiangMuInfoGetByChouQuMaResp> pingBiaoXiangMuInfoGetByChouQuMa(@RequestBody @Validated PingBiaoXiangMuInfoGetByChouQuMaReq req) {
        return ApiResult.successWithResult(expertService.getPingBiaoXiangMuInfoByChouQuMa(req));
    }

    @PostMapping("/pingBiaoXiangMu/page")
    public ApiResult<BasePageResp<Object>> pingBiaoXiangMuPage(@RequestBody @Validated PingBiaoXiangMuPageReq req) {
        return ApiResult.successWithResult(expertService.pagePingBiaoXiangMu(req));
    }

    // *** 请假/休假 ***
    // 个人请假
    @PostMapping("/qing-jia/jin-ji/page")
    public ApiResult<BasePageResp<Object>> qingJiaJinJiPage(@RequestBody @Validated QingJiaJinJiPageReq req) {
        return ApiResult.successWithResult(expertService.pageJinJiQingJia(req));
    }



    // *** 违规信息/冻结信息 ***
    // 违规信息
    /**
     * 专家个人违规记录查询
     * @param req
     * @return
     */
    @GetMapping("/wei-gui/ji-lu/page")
    public ApiResult<BasePageResp<WeiGuiPageResp>> weiGuiJiLuPage(@RequestBody @Validated WeiGuiJiLuPageReq req) {
        return ApiResult.successWithResult(expertService.pageWeiGuiList(req));
    }


    /**
     * 违规事项列表查询
     * @return
     */
    @GetMapping("wei-gui/shi-xiang-list")
    public ApiResult<List<WeiGuiPageResp.WeiGuiShiXiang>> weiGuiShiXiangList() {
        return ApiResult.successWithResult(expertService.listWeiGuiShiXiang());
    }


    /**
     * 专家违规处理信息详情查询
     * @param req
     * @return
     */
    @GetMapping("/wei-gui/chu-li-xiang-qing")
    public ApiResult<Object> weiGuiChuLiXiangQing(@RequestBody @Validated WeiGuiInfoByZhunaJiaWeiGuiGuidReq req) {
        return ApiResult.successWithResult(expertService.weiGuiChuLiXiangQing(req));
    }

    /**
     * 根据专家违规guid查询违规处理原因
     * @param req
     * @return
     */
    @GetMapping("/wei-gui/chu-li-yuan-yin")
    public ApiResult<Object> weiGuiChuLiYuanYin(@RequestBody @Validated WeiGuiInfoByZhunaJiaWeiGuiGuidReq req) {
        return ApiResult.successWithResult(expertService.weiGuiChuLiYuanYin());
    }

    /**
     * 专家违规（审核）处理记录查询
     * @param req
     * @return
     */
    @GetMapping("/wei-gui/chu-li-ji-lu")
    public ApiResult<Object> weiGuiChuLiJiLu(@RequestBody @Validated WeiGuiInfoByZhunaJiaWeiGuiGuidReq req) {
        return ApiResult.successWithResult(expertService.listWeiGuiChuLiJiLu());
    }


    // *** 课程培训  和  课后考试
    // 课后考试

    /**
     * 课后考试列表查询
     * @param req
     * @return
     */
    @PostMapping("/kaoShi/getKaoShiPage")
    public ApiResult<BasePageResp<KaoShiPageResp>> getKaoShiPage(@RequestBody @Validated KaoShiPageReq req) {
        return ApiResult.successWithResult(expertService.pageKaoShi(req));
    }





    // 课程培训

    /**
     * 培训课程列表查询
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunPage")
    public ApiResult<BasePageResp<PeiXunPageResp>> getPeiXunPage(@RequestBody @Validated PeiXunPageReq req) {
        return ApiResult.successWithResult(expertService.pagePeiXunKeCheng(req));
    }

    /**
     * 培训课程详情查询
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunInfo")
    public ApiResult<Object> getPeiXunInfo(@RequestBody @Validated PeiXunKeChengReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunInfo(req));
    }


    /**
     * 课程详情下课节列表
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunInfo")
    public ApiResult<Object> getPeiXunKeChengKeJieList(@RequestBody @Validated PeiXunKeChengReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunKeChengKeJieList(req));
    }
}
