package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.request.DongJieGetReq;
import com.cnooc.expert.controller.expert.model.request.DongJiePageReq;
import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaApplyReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaPageReq;
import com.cnooc.expert.controller.expert.model.request.KaoShiPageReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengKeJieFuJianGetReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengKeJieFuJianListReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengKeJieGetReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengKeJiePageReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunKeChengReq;
import com.cnooc.expert.controller.expert.model.request.PeiXunPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuByOwnerPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuInfoGetByChouQuMaReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuPageReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiApplyReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiPageReq;
import com.cnooc.expert.controller.expert.model.request.WeiGuiGetReq;
import com.cnooc.expert.controller.expert.model.request.WeiGuiJiLuPageReq;
import com.cnooc.expert.controller.expert.model.request.ZhuanJiaShenQingJiLuPageReq;
import com.cnooc.expert.controller.expert.model.response.ApproveBusinessIdGetResp;
import com.cnooc.expert.controller.expert.model.response.DongJieGetResp;
import com.cnooc.expert.controller.expert.model.response.GeRenXiuJiaApplyResp;
import com.cnooc.expert.controller.expert.model.response.GeRenXiuJiaPageResp;
import com.cnooc.expert.controller.expert.model.response.KaoShiPageResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJieFuJianGetResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJieFuJianListResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJieGetResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunKeChengKeJiePageResp;
import com.cnooc.expert.controller.expert.model.response.PeiXunPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuByOwnerPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoXiangMuPageResp;
import com.cnooc.expert.controller.expert.model.response.PingBiaoZhuanYeTreeNodeResp;
import com.cnooc.expert.controller.expert.model.response.QingJiaJinJiApplyResp;
import com.cnooc.expert.controller.expert.model.response.QingJiaJinJiPageResp;
import com.cnooc.expert.controller.expert.model.response.WeiGuiGetResp;
import com.cnooc.expert.controller.expert.model.response.ZhuanJiaShenQingJiLuPageResp;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import com.cnooc.expert.service.ExpertService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/expert")
public class ExpertController extends AbstractBaseController {

    private final ExpertService expertService;

    @PostMapping("/approve/getBusinessId")
    public ApiResult<ApproveBusinessIdGetResp> approveBusinessIdGet() {
        return ApiResult.successWithResult(expertService.getApproveBusinessId());
    }

    // *** 数据字典 ***

    /**
     * 民族查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/nofilter/list")
    public ApiResult<List<CommonNofilterEnumGetApiResp>> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        List<CommonNofilterEnumGetApiResp> apiResp = expertService.listDictNofilter(req);
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 集团二级单位列表
     *
     * @return
     */
    @PostMapping("/secondary-unit/list")
    public ApiResult<List<CommonJiTuanErJiDanWeiListApiResp>> secondaryUnitList() {
        List<CommonJiTuanErJiDanWeiListApiResp> apiResp = expertService.listSecondaryUnit();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 执业资格列表
     *
     * @return
     */
    @PostMapping("/dict/guid3/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud3List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict3();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 执业资格
     *
     * @return
     */
    @PostMapping("/dict/guid4/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud4List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict4();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 学历列表
     *
     * @return
     */
    @PostMapping("/dict/guid5/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud5List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict5();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 学位列表
     *
     * @return
     */
    @PostMapping("/dict/guid6/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud6List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict6();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 语种
     *
     * @return
     */
    @PostMapping("/dict/guid11/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud11List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict11();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 熟练程度
     *
     * @return
     */
    @PostMapping("/dict/guid12/list")
    public ApiResult<List<DictByParentListApiResp>> dictGuiud12List() {
        List<DictByParentListApiResp> apiResp = expertService.listDict12();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 评标专业树
     *
     * @return
     */
    @PostMapping("/ping-biao-zhuan-ye/tree")
    public ApiResult<List<PingBiaoZhuanYeTreeNodeResp>> PingBiaoZhuanYeTree() {
        List<PingBiaoZhuanYeTreeNodeResp> apiResp = expertService.treePingBiaoZhuanYe();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 省市区树
     *
     * @return
     */
    @PostMapping("/city/tree")
    public ApiResult<List<CityTreeApiResp>> CityTree() {
        List<CityTreeApiResp> apiResp = expertService.treeCity();
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 专家个人信息
     *
     * @return
     */
    @PostMapping("/info")
    public ApiResult<ExpertInfoGetApiResp> ExpertInfoGet() {
        ExpertInfoGetApiResp apiResp = expertService.getExpertInfo(null);
        return ApiResult.successWithResult(apiResp);
    }

    @PostMapping("/updateAllInfo")
    public ApiResult<ExpertInfoGetApiResp> ExpertInfoUpdate(@RequestBody @Validated ExpertInfoUpdateApiReq req) {
        ExpertInfoGetApiResp apiResp = expertService.updateExpetInfo(req);
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 抽取码详情
     *
     * @param req
     * @return
     */
    @PostMapping("/pingBiaoXiangMu/info-by-chouqunum")
    public ApiResult<XiangMuInfoByChouQuNumGetApiResp> pingBiaoXiangMuInfoGetByChouQuMa(@RequestBody @Validated PingBiaoXiangMuInfoGetByChouQuMaReq req) {
        XiangMuInfoByChouQuNumGetApiResp apiResp = expertService.getPingBiaoXiangMuInfoByChouQuMa(req);
        return ApiResult.successWithResult(apiResp);
    }

    @PostMapping("/pingBiaoXiangMu/page")
    public ApiResult<BasePageResp<PingBiaoXiangMuPageResp>> pingBiaoXiangMuPage(@RequestBody @Validated PingBiaoXiangMuPageReq req) {
        BasePageResp<PingBiaoXiangMuPageResp> apiResp = expertService.pagePingBiaoXiangMu(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 请假/休假 ***

    // 紧急请假分页列表
    @PostMapping("/qing-jia/page")
    public ApiResult<BasePageResp<QingJiaJinJiPageResp>> qingJiaJinJiPage(@RequestBody @Validated QingJiaJinJiPageReq req) {
        BasePageResp<QingJiaJinJiPageResp> apiResp = expertService.pageJinJiQingJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 紧急请假申请
    @PostMapping("/qing-jia/apply")
    public ApiResult<QingJiaJinJiApplyResp> qingJiaJinJiApply(@RequestBody @Validated QingJiaJinJiApplyReq req) {
        QingJiaJinJiApplyResp apiResp = expertService.applyJinJiQingJia(req);
        return ApiResult.successWithResult(apiResp);
    }


    // 个人休假分页列表
    @PostMapping("/xiu-jia/page")
    public ApiResult<BasePageResp<GeRenXiuJiaPageResp>> geRenXiuJiaPage(@RequestBody @Validated GeRenXiuJiaPageReq req) {
        BasePageResp<GeRenXiuJiaPageResp> apiResp = expertService.pageGeRenXiuJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 个人休假申请
    @PostMapping("/xiu-jia/apply")
    public ApiResult<GeRenXiuJiaApplyResp> geRenXiuJiaApply(@RequestBody @Validated GeRenXiuJiaApplyReq req) {
        GeRenXiuJiaApplyResp apiResp = expertService.applyGeRenXiuJia(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 评标项目 ***

    // 专家的评标项目分页列表
    @PostMapping("/ping-biao-xiang-mu/by-owner/page")
    public ApiResult<BasePageResp<PingBiaoXiangMuByOwnerPageResp>> pingBiaoXiangMuByOwnerPage(@RequestBody @Validated PingBiaoXiangMuByOwnerPageReq req) {
        BasePageResp<PingBiaoXiangMuByOwnerPageResp> apiResp = expertService.pagePingBiaoXiangmuByOwner(req);
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 专家个人的申请列表
     *
     * @param req
     * @return
     */
    @PostMapping("/zhuan-jia/shen-qing-ji-lu/page")
    public ApiResult<BasePageResp<ZhuanJiaShenQingJiLuPageResp>> zhuanJiaShenQingJiLuPage(@RequestBody @Validated ZhuanJiaShenQingJiLuPageReq req) {
        BasePageResp<ZhuanJiaShenQingJiLuPageResp> apiResp = expertService.pageZhuanJiaShenQingJiLu(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 违规信息/冻结信息 ***

    // 专家冻结信息分页列表
    @PostMapping("/dong-jie/page")
    public ApiResult<BasePageResp<DongJieZhuanYePageApiResp>> dongJiePage(@RequestBody @Validated DongJiePageReq req) {
        BasePageResp<DongJieZhuanYePageApiResp> apiResp = expertService.pageDongJie(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 专家冻结信息详情
    @PostMapping("/dong-jie/get")
    public ApiResult<DongJieGetResp> dongjieGet(@RequestBody @Validated DongJieGetReq req) {
        DongJieGetResp apiResp = expertService.getDongJie(req);
        return ApiResult.successWithResult(apiResp);
    }


    // 专家违规分页列表
    @PostMapping("/wei-gui/page")
    public ApiResult<BasePageResp<ViolationExpertPageApiResp>> weiGuiJiLuPage(@RequestBody @Validated WeiGuiJiLuPageReq req) {
        BasePageResp<ViolationExpertPageApiResp> apiResp = expertService.pageWeiGuiList(req);
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 专家违规处理信息详情
     *
     * @param req
     * @return
     */
    @PostMapping("/wei-gui/get")
    public ApiResult<WeiGuiGetResp> weiGuiGet(@RequestBody @Validated WeiGuiGetReq req) {
        return ApiResult.successWithResult(expertService.getWeiGui(req));
    }

    // *** 课程培训  和  课后考试
    // 课后考试

    /**
     * 课后考试列表查询
     *
     * @param req
     * @return
     */
    @PostMapping("/kaoShi/getKaoShiPage")
    public ApiResult<BasePageResp<KaoShiPageResp>> getKaoShiPage(@RequestBody @Validated KaoShiPageReq req) {
        return ApiResult.successWithResult(expertService.pageKaoShi(req));
    }


    // 课程培训

    /**
     * 培训课程列表查询
     *
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunPage")
    public ApiResult<BasePageResp<PeiXunPageResp>> getPeiXunPage(@RequestBody @Validated PeiXunPageReq req) {
        return ApiResult.successWithResult(expertService.pagePeiXunKeCheng(req));
    }

    /**
     * 培训课程详情查询
     *
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunInfo")
    public ApiResult<Object> getPeiXunInfo(@RequestBody @Validated PeiXunKeChengReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunInfo(req));
    }

    // 课程详情 课节列表 分页列表
    @PostMapping("/peiXun/kecheng/kejie/page")
    public ApiResult<BasePageResp<PeiXunKeChengKeJiePageResp>> pagePeiXunKeChengKeJie(@RequestBody @Validated PeiXunKeChengKeJiePageReq req) {
        return ApiResult.successWithResult(expertService.pagePeiXunKeChengKeJie(req));
    }

    // 课程详情 课节 详情
    @PostMapping("/peiXun/kecheng/kejie/get")
    public ApiResult<PeiXunKeChengKeJieGetResp> getPeiXunKeChengKeJie(@RequestBody @Validated PeiXunKeChengKeJieGetReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunKeChengKeJie(req));
    }

    // 课程详情 课节 附件 列表
    @PostMapping("/peiXun/kecheng/kejie/fujian/list")
    public ApiResult<List<PeiXunKeChengKeJieFuJianListResp>> listPeiXunKeChengKeJieFuJian(@RequestBody @Validated PeiXunKeChengKeJieFuJianListReq req) {
        return ApiResult.successWithResult(expertService.listPeiXunKeChengKeJieFuJian(req));
    }

    // 课程详情 课节 附件 详情
    @PostMapping("/peiXun/kecheng/kejie/fujian/get")
    public ApiResult<PeiXunKeChengKeJieFuJianGetResp> getPeiXunKeChengKeJieFuJian(@RequestBody @Validated PeiXunKeChengKeJieFuJianGetReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunKeChengKeJieFuJian(req));
    }

}
