package com.cnooc.expert.controller.subject;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.subject.model.request.CompanyPageReq;
import com.cnooc.expert.controller.subject.model.response.CompanyPageResp;
import com.cnooc.expert.service.SubjectService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/subject")
public class SubjectController extends AbstractBaseController {

    private final SubjectService subjectService;

    /**
     * 公司列表
     *
     * @return
     */
    @PostMapping("/company/page")
    public ApiResult<BasePageResp<CompanyPageResp>> companyPage(@RequestBody @Validated CompanyPageReq req) {
        BasePageResp<CompanyPageResp> apiResp = subjectService.pageCompany(req);

        return ApiResult.successWithResult(apiResp);
    }

}
