package com.cnooc.expert.external.expert.api;

import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.expert.model.request.CityTreeApiReq;
import com.cnooc.expert.external.expert.model.request.CommonJiTuanErJiDanWeiListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonNofilterEnumGetApiReq;
import com.cnooc.expert.external.expert.model.request.DictByParentListApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieZhuanYePageApiReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertPageApiReq;
import com.cnooc.expert.external.expert.model.request.XiangMuInfoByChouQuNumGetApiReq;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;

import java.util.List;
import java.util.Map;

public interface ExpertServiceApi {

    @POST("/api/mini/zjfw/zggrxxgl/queryInfoForEdit")
    Call<ApiBaseResult<ExpertInfoGetApiResp>> getExpertInfo(@HeaderMap Map<String, Object> headers, @Body ExpertInfoGetApiReq req);

    @POST("/api/mini/saas-expert/zjfw/zggrxxgl/updateAllInfo?type=1")
    Call<ApiBaseResult<ExpertInfoGetApiResp>> updateExpertInfoApi(@HeaderMap Map<String, Object> headers, @Body ExpertInfoUpdateApiReq req);

    /* 字典、枚举 */
    @POST("/api/mini/common/nofilter/getEnum")
    Call<ApiBaseResult<List<CommonNofilterEnumGetApiResp>>> getCommonNofilterEnum(@HeaderMap Map<String, Object> headers, @Body CommonNofilterEnumGetApiReq req);

    /* 字典、枚举 */
    @POST("/api/mini/common/listJiTuanErJiDanWei")
    Call<ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>>> listCommonJiTuanErJiDanWei(@HeaderMap Map<String, Object> headers, @Body CommonJiTuanErJiDanWeiListApiReq req);

    // 3职称 4职业资格信息 11 语种 12 熟练程度
    @POST("/api/mini/zjcq/ChouQuShenQing/queryDictByParent")
    Call<ApiBaseResult<List<DictByParentListApiResp>>> listDictByParent(@HeaderMap Map<String, Object> headers, @Body DictByParentListApiReq req);

    // 5学历   6学位
    @POST("/api/mini/xitongguanli/queryDictsByParentGuid")
    Call<ApiBaseResult<List<DictByParentListApiResp>>> listDictByParentGuid(@HeaderMap Map<String, Object> headers, @Body DictByParentListApiReq req);

    @POST("/api/mini/zjcq/ChouQuShenQing/queryCityTreeContainPartArea")
    Call<ApiBaseResult<List<CityTreeApiResp>>> cityTree(@HeaderMap Map<String, Object> headers, @Body CityTreeApiReq req);

    @POST("/api/mini/zjcq/quailfication/queryInfoByChouQuNum")
    Call<ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp>> xiangMuInfoByChouQuNumGetApi(@HeaderMap Map<String, Object> headers, @Body XiangMuInfoByChouQuNumGetApiReq req);

    /* 冻结、违规 */

    // 冻结
    @POST("/api/mini/zjgl/zhuanJiaPingBiaoZhuanYe/queryDongJieZhuanYeList")
    Call<ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>>> pageDongJieZhuanYeApi(@HeaderMap Map<String, Object> headers, @Body DongJieZhuanYePageApiReq req);

    // 违规
    @POST("/api/mini/zjgl/zjwg/pageViolationExpert")
    Call<ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>>> pageViolationExpertApi(@HeaderMap Map<String, Object> headers, @Body ViolationExpertPageApiReq req);

}
