package com.cnooc.expert.external.expert.service;

import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.expert.api.ExpertServiceApi;
import com.cnooc.expert.external.expert.model.request.CityTreeApiReq;
import com.cnooc.expert.external.expert.model.request.CommonJiTuanErJiDanWeiListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonNofilterEnumGetApiReq;
import com.cnooc.expert.external.expert.model.request.DictByParentListApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieZhuanYePageApiReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertPageApiReq;
import com.cnooc.expert.external.expert.model.request.XiangMuInfoByChouQuNumGetApiReq;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.List;
import java.util.Map;

@Service
public class ExpertServiceClient extends AbstractRetrofitManager {

    private final ExpertServiceApi expertServiceApi;

    public ExpertServiceClient(@Qualifier("retrofitExpert") Retrofit retrofit) {
        this.expertServiceApi = retrofit.create(ExpertServiceApi.class);
    }

    public ApiBaseResult<ExpertInfoGetApiResp> getExpertInfo(ExpertInfoGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ExpertInfoGetApiResp>> call = expertServiceApi.getExpertInfo(headers, req);
        return this.getResponseBody(call, "getExpertInfo");
    }

    public ApiBaseResult<ExpertInfoGetApiResp> updateExpertInfo(ExpertInfoUpdateApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ExpertInfoGetApiResp>> call = expertServiceApi.updateExpertInfoApi(headers, req);
        return this.getResponseBody(call, "updateExpertInfo");
    }

    public ApiBaseResult<List<CommonNofilterEnumGetApiResp>> getCommonNofilterEnum(CommonNofilterEnumGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CommonNofilterEnumGetApiResp>>> call = expertServiceApi.getCommonNofilterEnum(headers, req);
        return this.getResponseBody(call, "getCommonNofilterEnum");
    }

    public ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>> listCommonJiTuanErJiDanWei(CommonJiTuanErJiDanWeiListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>>> call = expertServiceApi.listCommonJiTuanErJiDanWei(headers, req);
        return this.getResponseBody(call, "listCommonJiTuanErJiDanWei");
    }

    public ApiBaseResult<List<DictByParentListApiResp>> listDictByParent(DictByParentListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<DictByParentListApiResp>>> call = expertServiceApi.listDictByParent(headers, req);
        return this.getResponseBody(call, "listDictByParent");
    }

    public ApiBaseResult<List<DictByParentListApiResp>> listDictByParentGuid(DictByParentListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<DictByParentListApiResp>>> call = expertServiceApi.listDictByParentGuid(headers, req);
        return this.getResponseBody(call, "listDictByParentGuid");
    }

    public ApiBaseResult<List<CityTreeApiResp>> treeCity(CityTreeApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CityTreeApiResp>>> call = expertServiceApi.cityTree(headers, req);
        return this.getResponseBody(call, "treeCity");
    }

    public ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp> getXiangMuInfoByChouQuNum(XiangMuInfoByChouQuNumGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp>> call = expertServiceApi.xiangMuInfoByChouQuNumGetApi(headers, req);
        return this.getResponseBody(call, "getXiangMuInfoByChouQuNum");
    }

    public ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>> pageDongJieZhuanYeApi(DongJieZhuanYePageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>>> call = expertServiceApi.pageDongJieZhuanYeApi(headers, req);
        return this.getResponseBody(call, "pageDongJieZhuanYeApi");
    }

    public ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>> pageViolationExpert(ViolationExpertPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>>> call = expertServiceApi.pageViolationExpertApi(headers, req);
        return this.getResponseBody(call, "pageViolationExpert");
    }

}
