package com.cnooc.expert.service;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.subject.model.request.CompanyPageReq;
import com.cnooc.expert.controller.subject.model.response.CompanyPageResp;
import com.cnooc.expert.external.subject.service.SubjectServiceClient;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class SubjectService {

    private SubjectServiceClient subjectServiceClient;

    public BasePageResp<CompanyPageResp> pageCompany(CompanyPageReq req) {
        List<CompanyPageResp> data = Lists.newArrayList(
                CompanyPageResp.builder()
                        .id("1420053958893662209")
                        .subjectId("1420053958767833088")
                        .subjectName("江苏瑞尔姆电器安安有限公司")
                        .businessType(5)
                        .creditCode("91320577MA4Y6K7H0F")
                        .contactPerson("张三")
                        .contactPhone("13800138000")
                        .contactEmail("zhangsan@cnooc.com.cn")
                        .build(),
                CompanyPageResp.builder()
                        .id("1420051042464067584")
                        .subjectId("1420051042065608705")
                        .subjectName("中海科技很大的公司")
                        .businessType(5)
                        .creditCode("91320507MA4Y6K7H0F")
                        .contactPerson("里斯")
                        .contactPhone("13333333333")
                        .contactEmail("lisi@cnooc.com.cn")
                        .build()
        );

        return BasePageResp.<CompanyPageResp>builder()
                .current(1)
                .pages(1)
                .total(2)
                .data(data)
                .build();
    }
}
