package com.cnooc.expert.common.response;

import com.cnooc.expert.common.exception.GlobalErrorCodeConstants;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Setter
@Getter
public class ApiResult<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 响应码
     */
    private Integer httpCode;

    /**
     * 响应消息
     */
    private String message;

    /**
     * 响应数据
     */
    private T result;


    public ApiResult(int httpCode, String message, T result) {
        this.httpCode = httpCode;
        this.message = message;
        this.result = result;
    }

    /**
     * 成功返回结果
     */
    public static <T> ApiResult<T> successWithResult(T result) {
        return new ApiResult<>(GlobalErrorCodeConstants.SUCCESS.getCode(), GlobalErrorCodeConstants.SUCCESS.getMsg(), result);
    }

    /**
     * 成功返回结果
     */
    public static <T> ApiResult<T> success() {
        return new ApiResult<>(GlobalErrorCodeConstants.SUCCESS.getCode(), GlobalErrorCodeConstants.SUCCESS.getMsg(), null);
    }

    public static <T> ApiResult<T> success(String message) {
        return new ApiResult<>(GlobalErrorCodeConstants.SUCCESS.getCode(), message, null);
    }

    /**
     * 失败返回结果
     */
    public static <T> ApiResult<T> error(String message) {
        return new ApiResult<>(GlobalErrorCodeConstants.SYSTEM_ERROR.getCode(), message, null);
    }

    /**
     * 失败返回结果
     */
    public static <T> ApiResult<T> error(int httpCode, String message) {
        return new ApiResult<>(httpCode, message, null);
    }

    // Getters and Setters

}
