package com.cnooc.expert.controller.expert.model.request;

import com.cnooc.expert.common.request.BasePageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author: FuHongZhang
 * @date 2025-11-15 14:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PeiXunPageReq extends BasePageRequest {

    /**
     * courseName 课程名称
     */
    private String courseName;

    /**
     * courseTypeGuid 课程类型Guid
     */
    private String courseTypeGuid;

    /**
     * courseTypeName 课程类型名称
     */
    private String courseTypeName;

    /**
     * courseReleaseStartTimestamp 课程发布时间查询开始时间
     */
    private Long courseReleaseStartTimestamp;

    /**
     * courseReleaseEndTimestamp 课程发布时间查询结束时间
     */
    private Long courseReleaseEndTimestamp;

    /**
     * 学习进度状态（10：未完成；20：已完成）
     */
    private Short progressStatus;

    /**
     * 当前用户guid
     */
    private String userGuid;

    /**
     * 当前用户guid
     */
    private String expertGuid;

    /**
     * 二开 - 排除的课程类型列表 （续期考试，续期培训）
     */
    private List<String> excludeCourseTypeList;

}
