package com.cnooc.expert.external.common.model.response;

import com.cnooc.expert.common.exception.GlobalErrorCodeConstants;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Setter
@Getter
public class ApiBaseResult<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 响应码
     */
    private Integer httpCode;

    /**
     * 响应消息
     */
    private String message;

    /**
     * 响应数据
     */
    private T result;


    public ApiBaseResult(int httpCode, String message, T result) {
        this.httpCode = httpCode;
        this.message = message;
        this.result = result;
    }

    /**
     * 成功返回结果
     */
    public static <T> ApiBaseResult<T> successWithResult(T result) {
        return new ApiBaseResult<>(GlobalErrorCodeConstants.SUCCESS.getCode(), GlobalErrorCodeConstants.SUCCESS.getMsg(), result);
    }

    /**
     * 成功返回结果
     */
    public static <T> ApiBaseResult<T> success() {
        return new ApiBaseResult<>(GlobalErrorCodeConstants.SUCCESS.getCode(), GlobalErrorCodeConstants.SUCCESS.getMsg(), null);
    }

    public static <T> ApiBaseResult<T> success(String message) {
        return new ApiBaseResult<>(GlobalErrorCodeConstants.SUCCESS.getCode(), message, null);
    }

    /**
     * 失败返回结果
     */
    public static <T> ApiBaseResult<T> error(String message) {
        return new ApiBaseResult<>(GlobalErrorCodeConstants.SYSTEM_ERROR.getCode(), message, null);
    }

    /**
     * 失败返回结果
     */
    public static <T> ApiBaseResult<T> error(int httpCode, String message) {
        return new ApiBaseResult<>(httpCode, message, null);
    }

    /**
     * 失败返回结果,并带有数据
     */
    public static <T> ApiBaseResult<T> errorWithResult(int httpCode, String message, T result) {

        return new ApiBaseResult<>(httpCode, message, result);
    }
    // Getters and Setters

}
