package com.cnooc.expert.external.subject.service;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.portal.model.request.AgentNumGetApiReq;
import com.cnooc.expert.external.portal.model.response.AgentNumGetApiResp;
import com.cnooc.expert.external.subject.api.SubjectServiceApi;
import com.cnooc.expert.external.subject.model.request.PlatformCompanyPageApiReq;
import com.cnooc.expert.external.subject.model.response.PlatformCompanyPageApiResp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Map;

@Service
public class SubjectServiceClient extends AbstractRetrofitManager {

    private final SubjectServiceApi subjectServiceApi;

    public SubjectServiceClient(@Qualifier("retrofitSubject") Retrofit retrofit) {
        this.subjectServiceApi = retrofit.create(SubjectServiceApi.class);
    }

    public ApiBaseResult<ApiBasePageResp<PlatformCompanyPageApiResp>> pagePlatformCompanyApi(PlatformCompanyPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<PlatformCompanyPageApiResp>>> call = subjectServiceApi.pagePlatformCompanyApi(headers, req);
        return super.getResponseBody(call, "pagePlatformCompanyApi");
    }

}
