package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.expert.model.request.*;
import com.cnooc.expert.controller.expert.model.response.*;
import com.cnooc.expert.service.ExpertService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/expert")
public class ExpertController extends AbstractBaseController {

    private final ExpertService expertService;

    @PostMapping("/approve/getBusinessId")
    public ApiResult<ApproveBusinessIdGetResp> approveBusinessIdGet() {
        return ApiResult.successWithResult(expertService.getApproveBusinessId());
    }

    // *** 数据字典 ***

    /**
     * 民族查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/nofilter/list")
    public ApiResult<List<NofilterListItemResp>> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        return ApiResult.successWithResult(expertService.listDictNofilter(req));
    }

    /**
     * 集团二级单位列表
     *
     * @return
     */
    @PostMapping("/secondary-unit/list")
    public ApiResult<List<SecondaryUnitListItemResp>> secondaryUnitList() {
        return ApiResult.successWithResult(expertService.listSecondaryUnit());
    }

    /**
     * 执业资格列表
     *
     * @return
     */
    @PostMapping("/dict/guid3/list")
    public ApiResult<List<DictListItemResp>> dictGuiud3List() {
        return ApiResult.successWithResult(expertService.listDict3());
    }

    /**
     * 执业资格
     *
     * @return
     */
    @PostMapping("/dict/guid4/list")
    public ApiResult<List<DictListItemResp>> dictGuiud4List() {
        return ApiResult.successWithResult(expertService.listDict4());
    }

    /**
     * 学历列表
     *
     * @return
     */
    @PostMapping("/dict/guid5/list")
    public ApiResult<List<DictListItemResp>> dictGuiud5List() {
        return ApiResult.successWithResult(expertService.listDict5());
    }

    /**
     * 学位列表
     *
     * @return
     */
    @PostMapping("/dict/guid6/list")
    public ApiResult<List<DictListItemResp>> dictGuiud6List() {
        return ApiResult.successWithResult(expertService.listDict6());
    }

    /**
     * 语种
     *
     * @return
     */
    @PostMapping("/dict/guid11/list")
    public ApiResult<List<DictListItemResp>> dictGuiud11List() {
        return ApiResult.successWithResult(expertService.listDict11());
    }

    /**
     * 熟练程度
     *
     * @return
     */
    @PostMapping("/dict/guid12/list")
    public ApiResult<List<DictListItemResp>> dictGuiud12List() {
        return ApiResult.successWithResult(expertService.listDict12());
    }

    /**
     * 评标专业树
     *
     * @return
     */
    @PostMapping("/ping-biao-zhuan-ye/tree")
    public ApiResult<List<PingBiaoZhuanYeTreeNodeResp>> PingBiaoZhuanYeTree() {
        return ApiResult.successWithResult(expertService.treePingBiaoZhuanYe());
    }

    /**
     * 省市区树
     *
     * @return
     */
    @PostMapping("/city/tree")
    public ApiResult<List<CityTreeNodeResp>> CityTree() {
        return ApiResult.successWithResult(expertService.treeCity());
    }

    /**
     * 公司列表
     *
     * @return
     */
    @PostMapping("/company/page")
    public ApiResult<BasePageResp<Object>> companyPage(@RequestBody @Validated CompanyPageReq req) {
        return ApiResult.successWithResult(expertService.pageCompany(req));
    }

    /**
     * 专家个人信息
     *
     * @return
     */
    @PostMapping("/info")
    public ApiResult<ExpertInfoGetResp> ExpertInfoGet() {
        return ApiResult.successWithResult(expertService.getExpertInfo(null));
    }

    /**
     * 抽取码详情
     *
     * @param req
     * @return
     */
    @PostMapping("/pingBiaoXiangMu/info-by-chouqunum")
    public ApiResult<PingBiaoXiangMuInfoGetByChouQuMaResp> pingBiaoXiangMuInfoGetByChouQuMa(@RequestBody @Validated PingBiaoXiangMuInfoGetByChouQuMaReq req) {
        return ApiResult.successWithResult(expertService.getPingBiaoXiangMuInfoByChouQuMa(req));
    }

    @PostMapping("/pingBiaoXiangMu/page")
    public ApiResult<BasePageResp<Object>> pingBiaoXiangMuPage(@RequestBody @Validated PingBiaoXiangMuPageReq req) {
        return ApiResult.successWithResult(expertService.pagePingBiaoXiangMu(req));
    }

    // *** 请假/休假 ***

    // 紧急请假分页列表
    @PostMapping("/qing-jia/page")
    public ApiResult<BasePageResp<Object>> qingJiaJinJiPage(@RequestBody @Validated QingJiaJinJiPageReq req) {
        return ApiResult.successWithResult(expertService.pageJinJiQingJia(req));
    }

    // 紧急请假申请
    @PostMapping("/qing-jia/apply")
    public ApiResult<QingJiaJinJiApplyResp> qingJiaJinJiApply(@RequestBody @Validated QingJiaJinJiApplyReq req) {
        return ApiResult.successWithResult(expertService.applyJinJiQingJia(req));
    }


    // 个人休假分页列表
    @PostMapping("/xiu-jia/page")
    public ApiResult<BasePageResp<Object>> geRenXiuJiaPage(@RequestBody @Validated GeRenXiuJiaPageReq req) {
        return ApiResult.successWithResult(expertService.pageGeRenXiuJia(req));
    }

    // 个人休假申请
    @PostMapping("/xiu-jia/apply")
    public ApiResult<GeRenXiuJiaApplyResp> geRenXiuJiaApply(@RequestBody @Validated GeRenXiuJiaApplyReq req) {
        return ApiResult.successWithResult(expertService.applyGeRenXiuJia(req));
    }

    // *** 评标项目 ***

    // 专家的评标项目分页列表
    @PostMapping("/ping-biao-xiang-mu/by-owner/page")
    public ApiResult<BasePageResp<Object>> pingBiaoXiangMuByOwnerPage(@RequestBody @Validated PingBiaoXiangMuByOwnerPageReq req) {
        return ApiResult.successWithResult(expertService.pagePingBiaoXiangmuByOwner(req));
    }

    /**
     * 专家个人的申请列表
     * @param req
     * @return
     */
    @PostMapping("/zhuan-jia/shen-qing-ji-lu/page")
    public ApiResult<BasePageResp<ZhuanJiaShenQingJiLuPageResp>> zhuanJiaShenQingJiLuPage(@RequestBody @Validated ZhuanJiaShenQingJiLuPageReq req) {
        return ApiResult.successWithResult(expertService.pageZhuanJiaShenQingJiLu(req));
    }

    // *** 违规信息/冻结信息 ***

    // 专家冻结信息分页列表
    @PostMapping("/dong-jie/page")
    public ApiResult<BasePageResp<DongJiePageResp>> dongJiePage(@RequestBody @Validated DongJiePageReq req) {
        return ApiResult.successWithResult(expertService.pageDongJie(req));
    }

    // 专家冻结信息详情
    @PostMapping("/dong-jie/get")
    public ApiResult<DongJieGetResp> dongjieGet(@RequestBody @Validated DongJieGetReq req) {
        return ApiResult.successWithResult(expertService.getDongJie(req));
    }


    // 专家违规分页列表
    @PostMapping("/wei-gui/page")
    public ApiResult<BasePageResp<WeiGuiPageResp>> weiGuiJiLuPage(@RequestBody @Validated WeiGuiJiLuPageReq req) {
        return ApiResult.successWithResult(expertService.pageWeiGuiList(req));
    }

    /**
     * 专家违规处理信息详情
     *
     * @param req
     * @return
     */
    @PostMapping("/wei-gui/get")
    public ApiResult<WeiGuiGetResp> weiGuiGet(@RequestBody @Validated WeiGuiGetReq req) {
        return ApiResult.successWithResult(expertService.getWeiGui(req));
    }

    // *** 课程培训  和  课后考试
    // 课后考试

    /**
     * 课后考试列表查询
     *
     * @param req
     * @return
     */
    @PostMapping("/kaoShi/getKaoShiPage")
    public ApiResult<BasePageResp<KaoShiPageResp>> getKaoShiPage(@RequestBody @Validated KaoShiPageReq req) {
        return ApiResult.successWithResult(expertService.pageKaoShi(req));
    }


    // 课程培训

    /**
     * 培训课程列表查询
     *
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunPage")
    public ApiResult<BasePageResp<PeiXunPageResp>> getPeiXunPage(@RequestBody @Validated PeiXunPageReq req) {
        return ApiResult.successWithResult(expertService.pagePeiXunKeCheng(req));
    }

    /**
     * 培训课程详情查询
     *
     * @param req
     * @return
     */
    @PostMapping("/peiXun/getPeiXunInfo")
    public ApiResult<Object> getPeiXunInfo(@RequestBody @Validated PeiXunKeChengReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunInfo(req));
    }

    // 课程详情 课节列表 分页列表
    @PostMapping("/peiXun/kecheng/kejie/page")
    public ApiResult<BasePageResp<PeiXunKeChengKeJiePageResp>> pagePeiXunKeChengKeJie(@RequestBody @Validated PeiXunKeChengKeJiePageReq req) {
        return ApiResult.successWithResult(expertService.pagePeiXunKeChengKeJie(req));
    }

    // 课程详情 课节 详情
    @PostMapping("/peiXun/kecheng/kejie/get")
    public ApiResult<PeiXunKeChengKeJieGetResp> getPeiXunKeChengKeJie(@RequestBody @Validated PeiXunKeChengKeJieGetReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunKeChengKeJie(req));
    }

    // 课程详情 课节 附件 列表
    @PostMapping("/peiXun/kecheng/kejie/fujian/list")
    public ApiResult<List<PeiXunKeChengKeJieFuJianListResp>> listPeiXunKeChengKeJieFuJian(@RequestBody @Validated PeiXunKeChengKeJieFuJianListReq req) {
        return ApiResult.successWithResult(expertService.listPeiXunKeChengKeJieFuJian(req));
    }

    // 课程详情 课节 附件 详情
    @PostMapping("/peiXun/kecheng/kejie/fujian/get")
    public ApiResult<PeiXunKeChengKeJieFuJianGetResp> getPeiXunKeChengKeJieFuJian(@RequestBody @Validated PeiXunKeChengKeJieFuJianGetReq req) {
        return ApiResult.successWithResult(expertService.getPeiXunKeChengKeJieFuJian(req));
    }

}
