package com.cnooc.expert.controller.expert.model.request;

import com.cnooc.expert.common.request.BasePageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author: FuHongZhang
 * @date 2025-11-15 13:58
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KaoShiPageReq extends BasePageRequest {

    /**
     * 课程名称
     */
    private String courseName;

    /**
     * 课程类型Guid
     */
    private String courseTypeGuid;

    /**
     * 课节名称
     */
    private String lessonName;

    /**
     * 课程发布时间查询开始时间
     */
    private Long courseReleaseStartTimestamp;

    /**
     * 课程发布时间查询结束时间
     */
    private Long courseReleaseEndTimestamp;

    /**
     * 考试状态
     */
    private Short examStatus;

    /**
     * 专家Guid todo 可能不需要传，需要从后端获取当前登录人guid
     */
    private String expertGuid;

    /**
     * 课程类型名称
     */
    private String courseTypeName;

    /**
     * 排除的课程类型列表   （续期培训，续期考试） 需要了解下业务，小程序端专家申请续期需要进行培训及考试吗
     */
    private List<String> excludeCourseTypeList;

}
