package com.cnooc.expert.controller.file;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.file.model.request.DownloadInfoReq;
import com.cnooc.expert.external.file.model.response.DownLoadInfoDTO;
import com.cnooc.expert.service.FileService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/file")
public class FileController extends AbstractBaseController {

    private final FileService fileService;

    @PostMapping("/generatorDownloadInfo")
    public ApiResult<List<DownLoadInfoDTO>> downloadInfo(@RequestBody @Validated DownloadInfoReq req) {
        List<DownLoadInfoDTO> apiResp = fileService.downloadInfo(req.getPathId());
        return ApiResult.successWithResult(apiResp);
    }

}
