package com.cnooc.expert.controller.workflow;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.response.InstStartApiResp;
import com.cnooc.expert.external.workflow.model.response.ProcDefPageApiResp;
import com.cnooc.expert.service.WorkflowService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/workflow")
public class WorkflowController extends AbstractBaseController {

    private final WorkflowService workflowService;

    // 流程实例启动
    @PostMapping("/start")
    public ApiResult<InstStartApiResp> instStart(@RequestBody @Validated InstStartApiReq req) {
        InstStartApiResp apiResp = workflowService.startInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 流程实例回撤
    @PostMapping("/revoke")
    public ApiResult<Boolean> instRevoke(@RequestBody @Validated InstRevokeApiReq req) {
        Boolean apiResp = workflowService.revokeInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 获取审批路径
    @PostMapping("/approve-path-setting/page")
    public ApiResult<BasePageResp<ProcDefPageApiResp>> pageApprovePathSetting(@RequestBody @Validated ApprovePathSettingPageReq req) {
        BasePageResp<ProcDefPageApiResp> apiResp = workflowService.pageApprovePathSetting(req);
        return ApiResult.successWithResult(apiResp);
    }

}
