package com.cnooc.expert.external.expert.model.response;

import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

@Data
@Builder
public class TrainCourseLessonGetApiResp {

    /**
     * lessonGuid 课节Guid
     */
    private String lessonGuid;

    /**
     * courseGuid 课程Guid
     */
    private String courseGuid;

    /**
     * testPaperGuid 试卷Guid
     */
    private String testPaperGuid;

    /**
     * lessonName 课节名称
     */
    private String lessonName;

    /**
     * learnFileGroupGuid 学习内容附件-文件组ID
     */
    private String learnFileGroupGuid;

    /**
     * learnContent 学习内容-文件名逗号分隔拼接
     */
    private String learnContent;

    /**
     * isTestAfterLearn 是否课后考试
     */
    private Boolean isTestAfterLearn;

    /**
     * 课节进度Guid
     */
    private String lessonProgressGuid;

    /**
     * 课节学习进度
     */
    private BigDecimal studyProgress;

    /**
     * 进度详情，存储视频进度关系及浏览文档进度关系（数据仅供前端使用）
     */
    private String progressDetails;

    /**
     * 学习时长
     * @date: 2023-8-15 11:32
     **/
    private int xueXiShiChang;

    /**
     * 累计学习时长
     * @date: 2023-8-15 11:32
     **/
    private Long leiJiXueXiShiChang;

}
