package com.cnooc.expert.external.workflow.api;

import com.cnooc.expert.external.common.model.request.ProcDefPageApiReq;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.common.model.response.ApiPagination;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.response.InstStartApiResp;
import com.cnooc.expert.external.workflow.model.response.ProcDefPageApiResp;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;

import java.util.Map;

public interface WorkflowServiceApi {

    @POST("/api/workflow2/expertManage/jingdongengine/findDefInfoListByCondition")
    Call<ApiBaseResult<ApiPagination<ProcDefPageApiResp>>> pageProcDefApi(@HeaderMap Map<String, Object> headers, @Body ProcDefPageApiReq req);

    @POST("/api/workflow2/expertManage/inst/start")
    Call<ApiBaseResult<InstStartApiResp>> startInstApi(@HeaderMap Map<String, Object> headers, @Body InstStartApiReq req);

    @POST("/api/workflow2/expertManage/inst/revoke")
    Call<ApiBaseResult<Void>> revokeInstApi(@HeaderMap Map<String, Object> headers, @Body InstRevokeApiReq req);

}
