package com.cnooc.expert.external.workflow.model.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.lang.Nullable;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;
import java.util.Map;

@Data
public class InstStartApiReq {

    // 企业id，按照当前的阶段传入对应的企业id，不传默认取当前登陆人企业id，平台审批的时候传入 0;
    private String subjectId;

    // 标题
    private String title;

    // 业务id
    private String businessId;

    // 事项类型 code
    private String busTypeCode;

    // 流程定义id
    private String procDefId;

    // 自定义任务信息（用户自定义审批人配置）
    @Valid
    @Nullable
    public List<TaskParticipantConfigReq> taskParticipantConfigs;

    // 流程实例抄送人
    private List<ApprovePersonReq> instCcParticipants;

    // 签名相关参数，传入会校验，不传不会校验
    private Map<String, Object> signatureMap;

    // 文件pathId
    private Long pathId;

    // 发起备注
    private String opinion;

    // 发起人自定义向上审批
    private Boolean customizeUpApproval;

    // 发起人设置限上岗人员
    private List<ApprovePersonReq> receiveParticipants;

    // 配置来源
    private Short engineType;

    /***************************************************对接审批流新统一方案*****************************************************/
    // 审批路径模板id
    private String templateId;

    // 审批路径模板名称
    private String templateName;

    // 审批路径模板名称
    private String steps;

    // 审批模板中每个审批节点中审批人的对应关系的json字符串
    private String controlApproveUser;

    // 限上岗审批信息
    private TemplateProConfigReq templateProConfig;

    // 需要下级审批
    private Boolean needNextApprove;

    // 接收人id
    private String receiveId;

    // 发起申请备注信息
    private String remark;

    // 发起申请附件信息
    private String attachment;

    // 主体名称
    private String subjectName;

    @Data
    public static class TaskParticipantConfigReq {

        // 任务定义的key值
        @NotBlank(message = "自定义任务键值不能为空")
        private String key;

        // 任务定义的名称
        private String name;

        // 是否拆分审批人组
        private Boolean allowSplitParty;

        // 任务（节点）抄送人
        @Valid
        private List<ApprovePersonReq> ccParticipants;

        // 审批人配置信息
        @Valid
        private List<ParticipantGroupDTO> participantGroups;
    }

    @Data
    public static class ApprovePersonReq {

        // id
        @NotNull(message = "审批人id 不能为空")
        private Long id;

        // 审批人名称
        @NotNull(message = "审批人名称 不能为空")
        private String name;
    }

    @Data
    public static class ParticipantGroupDTO {

        // 参与者类型：person-人员、orgHead-部门负责人、role-角色、trendsOrgHead-动态部门负责人、personVariable-人员变量
        @NotBlank(message = "参与者类型不能为空")
        @Pattern(
                regexp = "person|orgHead|role|trendsOrgHead|personVariable",
                message = "参与者类型现仅支持person-人员、orgHead-部门负责人、role-角色、trendsOrgHead-动态部门负责人、personVariable-人员变量"
        )
        private String type;

        /**
         * 是否需要 协助(秘书协助等)
         */
        // 是否需要 协助(秘书协助等)
        private Boolean needAssist;

        // 分组名称
        private String groupName;

        // 审批人
        private List<ParticipantApproveDTO> participants;
    }

    @Data
    public static class ParticipantApproveDTO {

        /**
         * 审批人分 用户 ， 角色 ， 部门等。。id 和 name 存对应的id和名称
         */
        // id
        @JsonFormat(shape = JsonFormat.Shape.STRING)
        private Long id;

        // 名称
        private String name;
    }

    @Data
    public static class TemplateProConfigReq {

        // 限上岗配置
        private String procurementConfigId;

        private String reason;

        // 限上岗人员信息
        private String personnel;

        private String upDomain;

        private String upward;

        // 签署意见
        private String signOpinion;
    }

}
