package com.cnooc.expert.common.utils;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

public class SmsHttpUtil {

    private static final RestTemplate restTemplate = new RestTemplate();

    /**
     * 发送 Base64 编码的 JSON POST 请求
     *
     * @param apiUrl      API 地址
     * @param requestBody 请求体 Map
     * @return 响应字符串
     */
    public static String sendPostRequest(String apiUrl, String requestBody) {
        try {
            // 设置请求头
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);

            // 构建请求实体
            HttpEntity<String> requestEntity = new HttpEntity<>(requestBody, headers);

            return restTemplate.postForObject(apiUrl, requestEntity, String.class);
        } catch (Exception e) {
            throw new RuntimeException("发送 POST 请求失败", e);
        }
    }
}
