package com.cnooc.expert.controller.workflow;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingPageResp;
import com.cnooc.expert.controller.workflow.model.response.InstStartResp;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.service.WorkflowMockService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/mock/workflow")
public class WorkflowMockController extends AbstractBaseController {

    private final WorkflowMockService workflowMockService;

    // 流程实例启动
    @PostMapping("/start")
    public ApiResult<InstStartResp> instStart(@RequestBody @Validated InstStartApiReq req) {
        InstStartResp apiResp = workflowMockService.startInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 流程实例回撤
    @PostMapping("/revoke")
    public ApiResult<Boolean> instRevoke(@RequestBody @Validated InstRevokeApiReq req) {
        Boolean apiResp = workflowMockService.revokeInst(req);
        return ApiResult.successWithResult(apiResp);
    }

    // 获取审批路径
    @PostMapping("/approve-path-setting/page")
    public ApiResult<BasePageResp<ApprovePathSettingPageResp>> pageApprovePathSetting(@RequestBody @Validated ApprovePathSettingPageReq req) {
        return ApiResult.successWithResult(workflowMockService.pageApprovePathSetting(req));
    }

}
