package com.cnooc.expert.external.expert.model.response;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class ExamPaperSubmitApiResp {

    private List<ShiTiManagerXiaoTi> shiTiError;

    private BigDecimal totalScore;

    @Data
    public static class ShiTiManagerXiaoTi {

        private String shiTiManagerXiaoTiGuid;//主键

        private String xiaoTiName;//小题题目名称

        private Long createTime;//创建时间

        private String creatorGuid;//创建人Guid

        private String creatorName;//创建人名称

        private Long modifyTime;//修改时间

        private String modifierGuid;//修改人Guid

        private String modifierName;//修改人名称

        private String shiTiManagerDaTiGuid;//题目所属大题的Guid

        private List<ShiTiManagerDaAn> daAnList;//小题对应的答案集合（oneToMany）

        private BigDecimal xiaoTiScore;//小题分值

        private String remark;//备注

        private ShiTiManagerDaTi daTi;//小题所属的大题（ManyToOne）

        private String userDaAnGuid;//专家考试时选中的答案Guid。  瞬时变量

    }

    public static class ShiTiManagerDaAn {

        private String shiTiManagerDaAnGuid;//主键

        private String daAnName;//答案名称

        private String isDaAn;//easyui BUG 须用字符串

        private Long createTime;

        private String creatorGuid;

        private String creatorName;

        private Long modifyTime;

        private String modifierGuid;

        private String modifierName;

        private String shiTiManagerXiaoTiGuid;//答案对应的题目Guid

        private Integer sort; //排序

    }

    @Data
    public static class ShiTiManagerDaTi {

        private String shiTiManagerDaTiGuid;//主键

        private String daTiName;//大题名称

        private BigDecimal xiaoTiScore;//大题下面每个小题的分数

        private Integer tiMuType;//题目类型  对应枚举TiMuType

        private String tiMuTypeText;

        private String remark;//备注

        private Long createTime;

        private String creatorGuid;

        private String creatorName;

        private Long modifyTime;

        private String modifierGuid;

        private String modifierName;

        private BigDecimal daTiScore;//大题总分值

    }

}
