package com.cnooc.expert.service;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.expert.model.request.CommonFuJianListReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.request.DongJieGetReq;
import com.cnooc.expert.controller.expert.model.request.DongJiePageReq;
import com.cnooc.expert.controller.expert.model.request.ExamQuestionXiaoTiListReq;
import com.cnooc.expert.controller.expert.model.request.ExamRecordSaveReq;
import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaApplyReq;
import com.cnooc.expert.controller.expert.model.request.GeRenXiuJiaPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuByOwnerPageReq;
import com.cnooc.expert.controller.expert.model.request.PingBiaoXiangMuInfoGetByChouQuMaReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiApplyReq;
import com.cnooc.expert.controller.expert.model.request.QingJiaJinJiPageReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseGetInfoReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseLessonGetReq;
import com.cnooc.expert.controller.expert.model.request.TrainCourseLessonPageReq;
import com.cnooc.expert.controller.expert.model.request.TrainCoursePageReq;
import com.cnooc.expert.controller.expert.model.request.TrainExamPageReq;
import com.cnooc.expert.controller.expert.model.request.WeiGuiGetReq;
import com.cnooc.expert.controller.expert.model.request.WeiGuiJiLuPageReq;
import com.cnooc.expert.controller.expert.model.request.ZhuanJiaShenQingJiLuPageReq;
import com.cnooc.expert.controller.expert.model.response.PingBiaoZhuanYeTreeNodeResp;
import com.cnooc.expert.controller.expert.model.response.ZhuanJiaShenQingJiLuPageResp;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.expert.model.request.CityTreeApiReq;
import com.cnooc.expert.external.expert.model.request.CommonFuJianListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonJiTuanErJiDanWeiListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonNofilterEnumGetApiReq;
import com.cnooc.expert.external.expert.model.request.DictByParentListApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieGetApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieZhuanYePageApiReq;
import com.cnooc.expert.external.expert.model.request.ExamPaperSubmitApiReq;
import com.cnooc.expert.external.expert.model.request.ExamQuestionListApiReq;
import com.cnooc.expert.external.expert.model.request.ExamQuestionXiaoTiListApiReq;
import com.cnooc.expert.external.expert.model.request.ExamRecordSaveApiReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetApiReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetReq;
import com.cnooc.expert.external.expert.model.request.GeRenXiuJiaApplyApiReq;
import com.cnooc.expert.external.expert.model.request.GeRenXiuJiaPageApiReq;
import com.cnooc.expert.external.expert.model.request.JinJiQingJiaApplyApiReq;
import com.cnooc.expert.external.expert.model.request.JinJiQingJiaPageApiReq;
import com.cnooc.expert.external.expert.model.request.TainLessonProgressUpdateApiReq;
import com.cnooc.expert.external.expert.model.request.TempExamPaperGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseLessonGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseLessonPageApiReq;
import com.cnooc.expert.external.expert.model.request.TrainExamPageApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertGetApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertPageApiReq;
import com.cnooc.expert.external.expert.model.request.XiangMuInfoByChouQuNumGetApiReq;
import com.cnooc.expert.external.expert.model.request.ZhuanJiaPingBiaoXiangMuRenWuPageApiReq;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonFuJianListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieGetApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExamPaperSubmitApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionXiaoTiListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamRecordSaveApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.TainLessonProgressUpdateApiResp;
import com.cnooc.expert.external.expert.model.response.TempExamPaperGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonPageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiReq;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainExamPageApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaInfoGetByBusinessIdApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaPingBiaoXiangMuRenWuPageApiResp;
import com.cnooc.expert.external.expert.service.ExpertServiceClient;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@AllArgsConstructor
@Service
public class ExpertService {

    private final ExpertServiceClient expertServiceClient;

    public String getApproveBusinessId() {
        ApiBaseResult<String> apiResp = expertServiceClient.getBusinessId();
        return apiResp.getData();
    }

    public List<CommonNofilterEnumGetApiResp> listDictNofilter(DictNofilterListReq req) {
        CommonNofilterEnumGetApiReq apiReq = CommonNofilterEnumGetApiReq.builder()
                .name("MinZu")
                .build();
        ApiBaseResult<List<CommonNofilterEnumGetApiResp>> apiResp = expertServiceClient.getCommonNofilterEnum(apiReq);

        return apiResp.getData();
    }

    public Long getSystemTime() {
        CommonNofilterEnumGetApiReq apiReq = CommonNofilterEnumGetApiReq.builder()
                .name("MinZu")
                .build();
        ApiBaseResult<Long> apiResp = expertServiceClient.getCommonNofilterSystemTime();

        return apiResp.getData();
    }

    public List<CommonJiTuanErJiDanWeiListApiResp> listSecondaryUnit() {
        CommonJiTuanErJiDanWeiListApiReq apiReq = CommonJiTuanErJiDanWeiListApiReq.builder()
                .tenantId(UserInfoUtils.TENANT_ID)
                .build();
        ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>> apiResp = expertServiceClient.listCommonJiTuanErJiDanWei(apiReq);

        return apiResp.getData();
    }

    public List<DictByParentListApiResp> listDict3() {
        DictByParentListApiReq apiReq = DictByParentListApiReq.builder()
                .parentGuid(3)
                .build();
        ApiBaseResult<List<DictByParentListApiResp>> apiResp = expertServiceClient.listDictByParent(apiReq);
        return apiResp.getData();
    }

    public List<DictByParentListApiResp> listDict4() {
        DictByParentListApiReq apiReq = DictByParentListApiReq.builder()
                .parentGuid(4)
                .build();
        ApiBaseResult<List<DictByParentListApiResp>> apiResp = expertServiceClient.listDictByParent(apiReq);
        return apiResp.getData();
    }

    public List<DictByParentListApiResp> listDict5() {
        DictByParentListApiReq apiReq = DictByParentListApiReq.builder()
                .parentGuid(5)
                .build();
        ApiBaseResult<List<DictByParentListApiResp>> apiResp = expertServiceClient.listDictByParentGuid(apiReq);
        return apiResp.getData();
    }

    public List<DictByParentListApiResp> listDict6() {
        DictByParentListApiReq apiReq = DictByParentListApiReq.builder()
                .parentGuid(6)
                .build();
        ApiBaseResult<List<DictByParentListApiResp>> apiResp = expertServiceClient.listDictByParentGuid(apiReq);
        return apiResp.getData();

    }

    public List<DictByParentListApiResp> listDict11() {
        DictByParentListApiReq apiReq = DictByParentListApiReq.builder()
                .parentGuid(11)
                .build();
        ApiBaseResult<List<DictByParentListApiResp>> apiResp = expertServiceClient.listDictByParent(apiReq);
        return apiResp.getData();
    }

    public List<DictByParentListApiResp> listDict12() {
        DictByParentListApiReq apiReq = DictByParentListApiReq.builder()
                .parentGuid(12)
                .build();
        ApiBaseResult<List<DictByParentListApiResp>> apiResp = expertServiceClient.listDictByParent(apiReq);
        return apiResp.getData();
    }

    public List<CityTreeApiResp> treeCity() {
        CityTreeApiReq apiReq = CityTreeApiReq.builder()
                .professionLevel(0)
                .build();
        ApiBaseResult<List<CityTreeApiResp>> apiResp = expertServiceClient.treeCity(apiReq);
        return apiResp.getData();
    }

    public ExpertInfoGetApiResp getExpertInfo(ExpertInfoGetReq req) {
        ExpertInfoGetApiReq apiReq = ExpertInfoGetApiReq.builder()
                .zhuanJiaGuid(UserInfoUtils.getExpertInfo().getZhuanJiaGuid())
                .build();
        ApiBaseResult<ExpertInfoGetApiResp> apiResp = expertServiceClient.getExpertInfo(apiReq);
        return apiResp.getData();
    }

    public ZhuanJiaInfoGetByBusinessIdApiResp getZhuanJiaInfoByBusinessId(String businessId) {
        ApiBaseResult<ZhuanJiaInfoGetByBusinessIdApiResp> apiResp = expertServiceClient.getZhuanJiaInfoByBusinessId(businessId);
        return apiResp.getData();
    }

    public ExpertInfoGetApiResp updateExpetInfo(ExpertInfoUpdateApiReq req) {
        ApiBaseResult<ExpertInfoGetApiResp> apiResp = expertServiceClient.updateExpertInfo(req);
        return apiResp.getData();
    }

    public XiangMuInfoByChouQuNumGetApiResp getPingBiaoXiangMuInfoByChouQuMa(PingBiaoXiangMuInfoGetByChouQuMaReq req) {
        XiangMuInfoByChouQuNumGetApiReq apiReq = XiangMuInfoByChouQuNumGetApiReq.builder()
                .chouQuNum(req.getChouQuNum())
                .build();
        ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp> apiResp = expertServiceClient.getXiangMuInfoByChouQuNum(apiReq);
        return apiResp.getData();
    }

    // 紧急请假分页
    public BasePageResp<JinJiQingJiaPageApiResp> pageJinJiQingJia(QingJiaJinJiPageReq req) {
        JinJiQingJiaPageApiReq.JinJiQingJiaVo qingJiaVo = JinJiQingJiaPageApiReq.JinJiQingJiaVo.builder()
                .zhuanJiaGuid(req.getZhuanJiaGuid())
                .qingJiaStartTime(req.getQingJiaStartTime())
                .qingJiaEndTime(req.getQingJiaEndTime())
                .build();
        JinJiQingJiaPageApiReq apiReq = JinJiQingJiaPageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .jinJiQingJiaVO(qingJiaVo)
                .build();
        ApiBaseResult<ApiBasePageResp<JinJiQingJiaPageApiResp>> apiResp = expertServiceClient.pageJinJiQingJia(apiReq);

        ApiBasePageResp<JinJiQingJiaPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<JinJiQingJiaPageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 紧急请假申请
    public JinJiQingJiaApplyApiResp applyJinJiQingJia(QingJiaJinJiApplyReq req) {
        JinJiQingJiaApplyApiReq apiReq = JinJiQingJiaApplyApiReq.builder()
                .chouQuQingKuangGuid(req.getChouQuQingKuangGuid())
                .chouQuRenWuGuid(req.getChouQuRenWuGuid())
                .jinJiQingJiaReason(req.getJinJiQingJiaReason())
                .qingJiaTime(req.getQingJiaTime())
                .build();
        ApiBaseResult<JinJiQingJiaApplyApiResp> apiResp = expertServiceClient.applyJinJiQingJia(apiReq);

        return apiResp.getData();
    }

    // 个人请假分页
    public BasePageResp<GeRenXiuJiaPageApiResp> pageGeRenXiuJia(GeRenXiuJiaPageReq req) {
        GeRenXiuJiaPageApiReq apiReq = GeRenXiuJiaPageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .zhuanJiaGuid(req.getZhuanJiaGuid())
                .qingJiaStartTime(req.getQingJiaStartTime())
                .qingJiaEndTime(req.getQingJiaEndTime())
                .build();
        ApiBaseResult<ApiBasePageResp<GeRenXiuJiaPageApiResp>> apiResp = expertServiceClient.pageGeRenXiuJia(apiReq);

        ApiBasePageResp<GeRenXiuJiaPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<GeRenXiuJiaPageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 个人休假申请
    public GeRenXiuJiaApplyApiResp applyGeRenXiuJia(GeRenXiuJiaApplyReq req) {
        GeRenXiuJiaApplyApiReq apiReq = GeRenXiuJiaApplyApiReq.builder()
                .zhuanJiaGuid(req.getZhuanJiaGuid())
                .startTime(req.getStartTime())
                .endTime(req.getEndTime())
                .qingJiaYuanYin(req.getQingJiaYuanYin())
                .qingJiaDays(req.getQingJiaDays())
                .build();
        ApiBaseResult<GeRenXiuJiaApplyApiResp> apiResp = expertServiceClient.applyGeRenXiuJia(apiReq);

        return apiResp.getData();
    }

    public List<PingBiaoZhuanYeTreeNodeResp> treePingBiaoZhuanYe() {

        List<PingBiaoZhuanYeTreeNodeResp> children3 = Lists.newArrayList(
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .zhuanYeGuid("1deba76c65ddace77e9f9d5284b8c64d")
                        .zhuanYeName("建设综合协调")
                        .zhuanYeBH("A070101")
                        .parentGuid("ff114e70bab3f20be5dc6f4d9b0a137a")
                        .zhuanYeShuXing(2)
                        .level(null)
                        .path("$$$A02$$$A0201$$$A020102$$$")
                        .children(Collections.emptyList())
                        .build(),
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .zhuanYeGuid("503fec1a9c6f911626797c4fa647b771")
                        .zhuanYeName("建设进度管理")
                        .zhuanYeBH("A070102")
                        .parentGuid("ff114e70bab3f20be5dc6f4d9b0a137a")
                        .zhuanYeShuXing(2)
                        .level(null)
                        .path("$$$A02$$$A0201$$$A020102$$$")
                        .children(Collections.emptyList())
                        .build()
        );
        List<PingBiaoZhuanYeTreeNodeResp> children2 = Lists.newArrayList(
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .zhuanYeGuid("ff114e70bab3f20be5dc6f4d9b0a137a")
                        .zhuanYeName("建设项目管理")
                        .zhuanYeBH("A0701")
                        .parentGuid("f34ee958d81545bd0196ec33e36e3c08")
                        .zhuanYeShuXing(2)
                        .level(null)
                        .path("$$$A02$$$A0201$$$")
                        .children(children3)
                        .build()
        );

        List<PingBiaoZhuanYeTreeNodeResp> children1 = Lists.newArrayList(
                PingBiaoZhuanYeTreeNodeResp.builder()
                        .zhuanYeGuid("f34ee958d81545bd0196ec33e36e3c08")
                        .zhuanYeName("项目管理(含代建)")
                        .zhuanYeBH("A07")
                        .parentGuid("0")
                        .zhuanYeShuXing(2)
                        .level(null)
                        .path("$$$A02$$$")
                        .children(children2)
                        .build()
        );

        return children1;
    }

    public BasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp> pagePingBiaoXiangmuByOwner(PingBiaoXiangMuByOwnerPageReq req) {
        ZhuanJiaPingBiaoXiangMuRenWuPageApiReq apiReq = ZhuanJiaPingBiaoXiangMuRenWuPageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .pingBiaoStartTime(req.getPingBiaoStartTime())
                .pingBiaoEndTime(req.getPingBiaoEndTime())
                .build();
        ApiBaseResult<ApiBasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>> apiResp = expertServiceClient.pageZhuanJiaPingBiaoXiangMuRenWu(apiReq);

        ApiBasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // ***** 违规、冻结 *****

    // 专家冻结分页
    public BasePageResp<DongJieZhuanYePageApiResp> pageDongJie(DongJiePageReq req) {
        DongJieZhuanYePageApiReq apiReq = DongJieZhuanYePageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .zhuanJiaGuid(UserInfoUtils.getExpertInfo().getZhuanJiaGuid())
                .build();
        ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>> apiResp = expertServiceClient.pageDongJieZhuanYe(apiReq);

        ApiBasePageResp<DongJieZhuanYePageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<DongJieZhuanYePageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 专家冻结详情
    public DongJieGetApiResp getDongJie(DongJieGetReq req) {
        DongJieGetApiReq apiReq = DongJieGetApiReq.builder()
                .pingBiaoZhuanYeGuid(req.getPingBiaoZhuanYeGuid())
                .build();
        ApiBaseResult<DongJieGetApiResp> apiResp = expertServiceClient.getDongJieExpert(apiReq);

        return apiResp.getData();
    }


    // 专家违规分页
    public BasePageResp<ViolationExpertPageApiResp> pageWeiGuiList(WeiGuiJiLuPageReq req) {
        ViolationExpertPageApiReq apiReq = ViolationExpertPageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .zhuanJiaGuid(req.getZhuanJiaGuid())
                .build();
        ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>> apiResp = expertServiceClient.pageViolationExpert(apiReq);

        ApiBasePageResp<ViolationExpertPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<ViolationExpertPageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 专家违规详情
    public ViolationExpertGetApiResp getWeiGui(WeiGuiGetReq req) {
        ViolationExpertGetApiReq apiReq = ViolationExpertGetApiReq.builder()
                .zhuanJiaGuid(req.getZhuanJiaGuid())
                .guid(req.getGuid())
                .build();
        ApiBaseResult<ViolationExpertGetApiResp> apiResp = expertServiceClient.getViolationExpert(apiReq);

        return apiResp.getData();
    }

    // ***** 培训 / 考试 *****

    private static final List<String> EXCLUDE_COURSE_TYPE_LIST = Lists.newArrayList("续期培训", "续期考试");

    // 培训课程分页
    public BasePageResp<TrainCoursePageApiResp> pageTrainCourse(TrainCoursePageReq req) {
        TrainCoursePageApiReq apiReq = TrainCoursePageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageNo())
                .userGuid(req.getZhuanJiaGuid())
                .progressStatus(0)
                .excludeCourseTypeList(EXCLUDE_COURSE_TYPE_LIST)
                .build();
        ApiBaseResult<ApiBasePageResp<TrainCoursePageApiResp>> apiResp = expertServiceClient.pageTrainCourse(apiReq);

        ApiBasePageResp<TrainCoursePageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<TrainCoursePageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 培训课程详情
    public TrainCourseGetApiResp getTrainCourse(TrainCourseGetInfoReq req) {
        TrainCourseGetApiReq apiReq = TrainCourseGetApiReq.builder()
                .courseGuid(req.getCourseGuid())
                .build();
        ApiBaseResult<TrainCourseGetApiResp> apiResp = expertServiceClient.getTrainCourse(apiReq);

        return apiResp.getData();
    }

    // 培训课程课节分页
    public BasePageResp<TrainCourseLessonPageApiResp> pageTrainCourseLesson(TrainCourseLessonPageReq req) {
        TrainCourseLessonPageApiReq apiReq = TrainCourseLessonPageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .courseGuid(req.getCourseGuid())
                .userGuid(req.getZhuanJiaGuid())
                .build();
        ApiBaseResult<ApiBasePageResp<TrainCourseLessonPageApiResp>> apiResp = expertServiceClient.pageTrainCourseLesson(apiReq);

        ApiBasePageResp<TrainCourseLessonPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<TrainCourseLessonPageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 培训课程课节详情
    public TrainCourseLessonGetApiResp getTrainCourseLesson(TrainCourseLessonGetReq req) {
        TrainCourseLessonGetApiReq apiReq = TrainCourseLessonGetApiReq.builder()
                .lessonGuid(req.getLessonGuid())
                .build();
        ApiBaseResult<TrainCourseLessonGetApiResp> apiResp = expertServiceClient.getTrainCourseLesson(apiReq);

        return apiResp.getData();
    }

    // 附件列表
    public List<CommonFuJianListApiResp> listCommonFuJian(CommonFuJianListReq req) {
        CommonFuJianListApiReq apiReq = CommonFuJianListApiReq.builder()
                .groupGuid(req.getGroupGuid())
                .build();
        ApiBaseResult<List<CommonFuJianListApiResp>> apiResp = expertServiceClient.listCommonFuJian(apiReq);
        return apiResp.getData();
    }

    // 更新培训课节学习进度
    public TainLessonProgressUpdateApiResp updateTainLessonProgress(TainLessonProgressUpdateApiReq req) {
        ApiBaseResult<TainLessonProgressUpdateApiResp> apiResp = expertServiceClient.updateTainLessonProgress(req);
        return apiResp.getData();
    }

    // 考试分页
    public BasePageResp<TrainExamPageApiResp> pageTrainExam(TrainExamPageReq req) {
        TrainExamPageApiReq apiReq = TrainExamPageApiReq.builder()
                .page(req.getPageNo())
                .rows(req.getPageSize())
                .expertGuid(req.getZhuanJiaGuid())
                .excludeCourseTypeList(EXCLUDE_COURSE_TYPE_LIST)
                .build();
        ApiBaseResult<ApiBasePageResp<TrainExamPageApiResp>> apiResp = expertServiceClient.pageTrainExam(apiReq);

        ApiBasePageResp<TrainExamPageApiResp> pageResp = apiResp.getData();

        return BasePageResp.<TrainExamPageApiResp>builder()
                .current(pageResp.getCurrent())
                .pages(pageResp.getPages())
                .total(pageResp.getTotal())
                .data(pageResp.getData())
                .build();
    }

    // 考试试卷信息
    public TempExamPaperGetApiResp getTempExamPaper(String examPaperGuid) {
        TempExamPaperGetApiReq apiReq = TempExamPaperGetApiReq.builder()
                .examPaperGuid(examPaperGuid)
                .build();
        ApiBaseResult<TempExamPaperGetApiResp> apiResp = expertServiceClient.getTempExamPaper(apiReq);

        return apiResp.getData();
    }

    // 保存考试记录
    public ExamRecordSaveApiResp saveExamRecord(ExamRecordSaveReq req) {
        ExamRecordSaveApiReq apiReq = ExamRecordSaveApiReq.builder()
                .zhuanJiaGuid(req.getZhuanJiaGuid())
                .shiJuanGuid(req.getShiJuanGuid())
                .lessonGuid(req.getLessonGuid())
                .courseGuid(req.getCourseGuid())
                .businessExamGuid(req.getBusinessExamGuid())
                .examType(req.getExamType())
                .build();
        ApiBaseResult<ExamRecordSaveApiResp> apiResp = expertServiceClient.saveExamRecord(apiReq);

        return apiResp.getData();
    }

    // 考试试题列表
    public List<ExamQuestionListApiResp> listExamQuestion(String examPaperGuid) {
        ExamQuestionListApiReq apiReq = ExamQuestionListApiReq.builder()
                .examPaperGuid(examPaperGuid)
                .build();
        ApiBaseResult<List<ExamQuestionListApiResp>> apiResp = expertServiceClient.listExamQuestion(apiReq);

        return apiResp.getData();
    }

    // 考试试题小题列表
    public List<ExamQuestionXiaoTiListApiResp> listExamQuestionXiaoTi(ExamQuestionXiaoTiListReq req) {
        ExamQuestionXiaoTiListApiReq apiReq = ExamQuestionXiaoTiListApiReq.builder()
                .shiJuanGuid(req.getShiJuanGuid())
                .daTiGuid(req.getDaTiGuid())
                .build();
        ApiBaseResult<List<ExamQuestionXiaoTiListApiResp>> apiResp = expertServiceClient.listExamQuestionXiaoTi(apiReq);

        return apiResp.getData();
    }

    // 提交试卷
    public ExamPaperSubmitApiResp submitExamPaper(ExamPaperSubmitApiReq req) {
        ApiBaseResult<ExamPaperSubmitApiResp> apiResp = expertServiceClient.submitExamPaper(req);
        return apiResp.getData();
    }

    public BasePageResp<ZhuanJiaShenQingJiLuPageResp> pageZhuanJiaShenQingJiLu(ZhuanJiaShenQingJiLuPageReq req) {
        ArrayList<ZhuanJiaShenQingJiLuPageResp> list = Lists.newArrayList(
                ZhuanJiaShenQingJiLuPageResp.builder()
                        .bianGengXuHao(null)
                        .businessId("1438482566640164864")
                        .createTime(1763002577535L)
                        .createTimeText("2025-11-13 10:56:17")
                        .creatorName("物装中心十七")
                        .currentNode("expertModifyApply-innerApprove")
                        .daiShenRenGuids("")
                        .daiShenRenNames("")
                        .isDeleted(false)
                        .isFinish(false)
                        .mobile("15900000017")
                        .modifierName("物装中心十七")
                        .modifyTime(1763002676888L)
                        .modifyTimeText("2025-11-13 10:57:58")
                        .nengCheHui(false)
                        .photoGuid("")
                        .remark("")
                        .sequence(null)
                        .shenFenZheng("123431198502127465")
                        .shenHeRenGuid("")
                        .shenPiBuMenGuid("")
                        .shenPiBuMenName("b66065b5-3f4a-4b98-bdf5-4374d3350aef")
                        .shenPiJiLuGuid("")
                        .shenPiRen("")
                        .shenPiShiJian(null)
                        .shenPiYiJian("")
                        .shenPiZhuangTai((short) 2)
                        .shenQingLeiXing(105)
                        .shiFouZhuanJiao(false)
                        .shiXiangGuid("")
                        .shiXiangName("")
                        .shiXiangType(null)
                        .shouLiRen("")
                        .shouLiTime(null)
                        .shouLiTimeText(null)
                        .shouLiZhuanTai((short) 2)
                        .tiJiaoRenGuid("")
                        .tiJiaoRenName("")
                        .tiJiaoTime(null)
                        .tiJiaoTimeText(null)
                        .tuiKuYuanYin("")
                        .workFlowBusinessId("1438482566640164864")
                        .workFlowBusinessIdNew(null)
                        .xiaJiShenHeRenGuid("")
                        .xiaJiShenHeRenName("")
                        .xiangMuGuid("")
                        .zhuanJiaGuid("")
                        .zhuanJiaShiXiangGuid("")
                        .build()
        );

        return BasePageResp.<ZhuanJiaShenQingJiLuPageResp>builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(list)
                .build();
    }
}
