package com.cnooc.expert.auth.service;

public interface SmsService {

    /**
     * 校验短信验证码
     *
     * @param phone 手机号
     * @param code  验证码
     * @return 是否校验通过
     */
    boolean verifySmsCode(String phone, String code);

    /**
     * 发送短信验证码
     *
     * @param phone 手机号
     * @return 是否发送成功
     */
    boolean sendSmsCode(String phone,int smsTemplateType);

    boolean sendGlySmsCode(String phone,int smsTemplateType);

    boolean sendGlySmsContent(String phone, String content, String code);

    void asyncSendGlySmsContent(String phone, String content, String code);
}

