/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.pdf;

import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFUtil.class);
    private int cursorPage;

    public static List<Float[]> getSignLocate(byte[] pdfIn, String signKeyWord, boolean isAll, int page) {
        PDFUtil pdfUtil = new PDFUtil();
        return pdfUtil.searchLocation(pdfIn, signKeyWord, isAll, page);
    }

    public static int checkLocate(byte[] pdfIn, float x, float y, int page) {
        int pageNum;
        try {
            PdfReader pdfReader = new PdfReader(pdfIn);
            pageNum = pdfReader.getNumberOfPages();
            if (page <= 0 || page > pageNum) {
                return -1;
            }
            Rectangle pageSize = pdfReader.getPageSize(1);
            float height = pageSize.getHeight();
            float width = pageSize.getWidth();
            if (height < y || width < x || x < 0.0f || y < 0.0f) {
                return -1;
            }
        }
        catch (Exception e) {
            LOGGER.error("PDFUtil.checkLocate() error.", (Throwable)e);
            return -1;
        }
        return pageNum;
    }

    public List<Float[]> searchLocation(byte[] pdfIn, final String signKeyWord, boolean isAll, int page) {
        final ArrayList<Float[]> signLocateList = new ArrayList<Float[]>();
        try {
            PdfReader pdfReader = new PdfReader(pdfIn);
            int pageNum = pdfReader.getNumberOfPages();
            if (page <= 0 || page > pageNum) {
                return signLocateList;
            }
            PdfReaderContentParser pdfReaderContentParser = new PdfReaderContentParser(pdfReader);
            int endPage = isAll ? pageNum : page;
            this.cursorPage = page;
            while (this.cursorPage <= endPage) {
                LOGGER.info("searchLocation ### startPage = {}, endPage = {}, cursorPage = {}", new Object[]{page, endPage, this.cursorPage});
                pdfReaderContentParser.processContent(this.cursorPage, new RenderListener(){

                    public void renderText(TextRenderInfo renderInfo) {
                        String text = renderInfo.getText();
                        if (null != text && text.contains(signKeyWord)) {
                            Rectangle2D.Float boundingRectange = renderInfo.getBaseline().getBoundingRectange();
                            Float[] signLocateArrs = new Float[]{Float.valueOf(boundingRectange.x), Float.valueOf(boundingRectange.y), Float.valueOf(boundingRectange.width), Float.valueOf(boundingRectange.height), Float.valueOf(PDFUtil.this.cursorPage)};
                            signLocateList.add(signLocateArrs);
                        }
                    }

                    public void renderImage(ImageRenderInfo renderInfo) {
                    }

                    public void endTextBlock() {
                    }

                    public void beginTextBlock() {
                    }
                });
                ++this.cursorPage;
            }
        }
        catch (Exception e) {
            LOGGER.error("PDFUtil.getSignLocate() error.", (Throwable)e);
        }
        return signLocateList;
    }
}

