package com.cnooc.expert.external.expert.service;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.expert.api.ExpertServiceApi;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetTestResp;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Map;

@Service
public class ExpertServiceClient extends AbstractRetrofitManager {

    private final ExpertServiceApi expertServiceApi;

    public ExpertServiceClient(@Qualifier("retrofitExpert") Retrofit retrofit) {
        this.expertServiceApi = retrofit.create(ExpertServiceApi.class);
    }

    public ExpertInfoGetTestResp getExpertInfo(long id) {
        Map<String, Object> headers = Maps.newHashMap();
        Call<ExpertInfoGetTestResp> call = expertServiceApi.expertDetailGet(headers);

        return this.getResponseBody(call, "getExpertInfo");
    }
}
