package com.cnooc.expert.auth.service;

import com.cnooc.expert.system.entity.pojo.ZhuanJiaUser;
import com.cnooc.expert.system.entity.vo.LoginVO;
import com.cnooc.expert.system.entity.vo.VerifyCodeVO;

public interface LoginService {

    /**
     * 登录，兼容短信登录和密码登录
     * @param loginVO
     * @return
     */
    String login(LoginVO loginVO);

    /**
     * 发送短信验证码
     * @param vo
     * @return
     */
    String sendPhoneCode(LoginVO vo);

    /**
     * 修改密码
     * @param loginVO
     * @return
     */
    String changePass(LoginVO loginVO);

    /**
     * 验证码验证接口
     * @param codeVO
     * @return
     */
    String verifyCode(VerifyCodeVO codeVO);

    /**
     * 根据token查询专家基础信息
     * @param token
     * @return
     */
    ZhuanJiaUser getZhuanJiaUserByToken(String token);
}
