package com.cnooc.expert.external.workflow.api;

import com.cnooc.expert.external.common.model.request.ProcDefPageApiReq;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.common.model.response.ApiPagination;
import com.cnooc.expert.external.workflow.model.request.ApprovePathSettingByConditionGetApiReq;
import com.cnooc.expert.external.workflow.model.request.ApprovePathSettingSaveOrUpdateApiReq;
import com.cnooc.expert.external.workflow.model.request.InstCalculateApiReq;
import com.cnooc.expert.external.workflow.model.request.InstExistedQueryApiReq;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.response.ApprovePathSettingByConditionGetApiResp;
import com.cnooc.expert.external.workflow.model.response.InstCalculateApiResp;
import com.cnooc.expert.external.workflow.model.response.InstStartApiResp;
import com.cnooc.expert.external.workflow.model.response.ProcDefPageApiResp;
import com.cnooc.expert.external.workflow.model.response.ReceiveSettingByConditionFindApiResp;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;
import retrofit2.http.Query;

import java.util.List;
import java.util.Map;

public interface WorkflowServiceApi {

    @POST("/api/workflow2/expertManage/jingdongengine/findDefInfoListByCondition")
    Call<ApiBaseResult<ApiPagination<ProcDefPageApiResp>>> pageProcDefApi(@HeaderMap Map<String, Object> headers, @Body ProcDefPageApiReq req);

    @POST("/api/workflow2/expertManage/inst/start")
    Call<ApiBaseResult<InstStartApiResp>> startInstApi(@HeaderMap Map<String, Object> headers, @Body InstStartApiReq req);

    @POST("/api/workflow2/expertManage/inst/revoke")
    Call<ApiBaseResult<Void>> revokeInstApi(@HeaderMap Map<String, Object> headers, @Body InstRevokeApiReq req);

    // 计算是否需要审批, 需要审批返回能使用的模板信息
    @POST("/api/workflow2/expertManage/inst/calculate")
    Call<ApiBaseResult<InstCalculateApiResp>> calculateInstApi(@HeaderMap Map<String, Object> headers, @Body InstCalculateApiReq req);

    // 保存、编辑审批路径配置
    @POST("/api/workflow2/expertManage/jingdongengine/saveOrUpdateApprovePathSetting")
    Call<ApiBaseResult<Void>> saveOrUpdateApprovePathSettingApi(@HeaderMap Map<String, Object> headers, @Body ApprovePathSettingSaveOrUpdateApiReq req);

    // 获取审批模版
    @POST("/api/workflow2/expertManage/jingdongengine/getApprovePathSettingByCondition")
    Call<ApiBaseResult<ApprovePathSettingByConditionGetApiResp>> getApprovePathSettingByConditionApi(@HeaderMap Map<String, Object> headers, @Body ApprovePathSettingByConditionGetApiReq req);

    // 按照条件查询限上岗配置 - 没数据表示不需要配置限上岗
    @GET("/api/workflow2/expertManage/jingdongengine/fingReceiveSettingByCondition")
    Call<ApiBaseResult<List<ReceiveSettingByConditionFindApiResp>>> findReceiveSettingByConditionApi(
            @Query("businessId") String businessId,
            @Query("businessTypeCode") String businessTypeCode,
            @Query("subjectId") String subjectId,
            @Query("subjectName") String subjectName
    );

    @POST("/api/workflow2/expertManage/management/qryInstExisted")
    Call<ApiBaseResult<Boolean>> queryInstExistedApi(@HeaderMap Map<String, Object> headers, @Body InstExistedQueryApiReq req);

}
